/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.batch.api.listener.JobListener;
import org.springframework.batch.core.listener.ListenerMetaData;

public enum JsrJobListenerMetaData implements ListenerMetaData
{
    BEFORE_JOB("beforeJob", "jsr-before-job"),
    AFTER_JOB("afterJob", "jsr-after-job");

    private final String methodName;
    private final String propertyName;
    private static final Map<String, JsrJobListenerMetaData> propertyMap;

    private JsrJobListenerMetaData(String methodName, String propertyName) {
        this.methodName = methodName;
        this.propertyName = propertyName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return null;
    }

    @Override
    public Class<?> getListenerInterface() {
        return JobListener.class;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Class<?>[] getParamTypes() {
        return new Class[0];
    }

    public static JsrJobListenerMetaData fromPropertyName(String propertyName) {
        return propertyMap.get(propertyName);
    }

    static {
        propertyMap = new HashMap<String, JsrJobListenerMetaData>();
        for (JsrJobListenerMetaData metaData : JsrJobListenerMetaData.values()) {
            propertyMap.put(metaData.getPropertyName(), metaData);
        }
    }
}

