/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.util.Assert;

public class Jackson2ExecutionContextStringSerializer
implements ExecutionContextSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public Jackson2ExecutionContextStringSerializer() {
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        this.objectMapper.enableDefaultTyping();
        this.objectMapper.registerModule((Module)new JobParametersModule());
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper.copy();
        this.objectMapper.registerModule((Module)new JobParametersModule());
    }

    public Map<String, Object> deserialize(InputStream in) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)this.objectMapper.readValue(in, (TypeReference)typeRef);
    }

    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, (String)"A context is required");
        Assert.notNull((Object)out, (String)"An OutputStream is required");
        this.objectMapper.writeValue(out, context);
    }

    private class JobParametersModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        private JobParametersModule() {
            super("Job parameters module");
            this.setMixInAnnotation(JobParameters.class, JobParametersMixIn.class);
            this.addDeserializer(JobParameter.class, (JsonDeserializer)new JobParameterDeserializer());
        }

        private class JobParameterDeserializer
        extends StdDeserializer<JobParameter> {
            private static final long serialVersionUID = 1L;
            private static final String IDENTIFYING_KEY_NAME = "identifying";
            private static final String TYPE_KEY_NAME = "type";
            private static final String VALUE_KEY_NAME = "value";

            JobParameterDeserializer() {
                super(JobParameter.class);
            }

            public JobParameter deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                JsonNode node = (JsonNode)parser.readValueAsTree();
                boolean identifying = node.get(IDENTIFYING_KEY_NAME).asBoolean();
                String type = node.get(TYPE_KEY_NAME).asText();
                JsonNode value = node.get(VALUE_KEY_NAME);
                switch (JobParameter.ParameterType.valueOf(type)) {
                    case STRING: {
                        String parameterValue = value.asText();
                        return new JobParameter(parameterValue, identifying);
                    }
                    case DATE: {
                        Date parameterValue = new Date(value.get(1).asLong());
                        return new JobParameter(parameterValue, identifying);
                    }
                    case LONG: {
                        Long parameterValue = value.get(1).asLong();
                        return new JobParameter(parameterValue, identifying);
                    }
                    case DOUBLE: {
                        Double parameterValue = value.asDouble();
                        return new JobParameter(parameterValue, identifying);
                    }
                }
                return null;
            }
        }

        private abstract class JobParametersMixIn {
            private JobParametersMixIn() {
            }

            @JsonIgnore
            abstract boolean isEmpty();
        }
    }
}

