/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public abstract class BatchScopeSupport
implements Scope,
BeanFactoryPostProcessor,
Ordered {
    private boolean autoProxy = true;
    private boolean proxyTargetClass = false;
    private String name;
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public void setAutoProxy(boolean autoProxy) {
        this.autoProxy = autoProxy;
    }

    public abstract String getTargetNamePrefix();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(this.name, (Scope)this);
        if (!this.autoProxy) {
            return;
        }
        Assert.state((boolean)(beanFactory instanceof BeanDefinitionRegistry), (String)"BeanFactory was not a BeanDefinitionRegistry, so JobScope cannot be used.");
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            if (beanName.startsWith(this.getTargetNamePrefix())) continue;
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            boolean scoped = this.name.equals(definition.getScope());
            Scopifier scopifier = new Scopifier(registry, this.name, this.proxyTargetClass, scoped);
            scopifier.visitBeanDefinition(definition);
            if (!scoped || definition.isAbstract()) continue;
            BatchScopeSupport.createScopedProxy(beanName, definition, registry, this.proxyTargetClass);
        }
    }

    protected static BeanDefinitionHolder createScopedProxy(String beanName, BeanDefinition definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(definition, beanName), (BeanDefinitionRegistry)registry, (boolean)proxyTargetClass);
        registry.registerBeanDefinition(beanName, proxyHolder.getBeanDefinition());
        return proxyHolder;
    }

    protected static class Scopifier
    extends BeanDefinitionVisitor {
        private final boolean proxyTargetClass;
        private final BeanDefinitionRegistry registry;
        private final String scope;
        private final boolean scoped;

        public Scopifier(BeanDefinitionRegistry registry, String scope, boolean proxyTargetClass, boolean scoped) {
            super(new StringValueResolver(){

                public String resolveStringValue(String value) {
                    return value;
                }
            });
            this.registry = registry;
            this.proxyTargetClass = proxyTargetClass;
            this.scope = scope;
            this.scoped = scoped;
        }

        protected Object resolveValue(Object value) {
            BeanDefinition definition = null;
            String beanName = null;
            if (value instanceof BeanDefinition) {
                definition = (BeanDefinition)value;
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)this.registry);
            } else if (value instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder holder = (BeanDefinitionHolder)value;
                definition = holder.getBeanDefinition();
                beanName = holder.getBeanName();
            }
            if (definition != null) {
                boolean scopeChangeRequiresProxy;
                boolean nestedScoped = this.scope.equals(definition.getScope());
                boolean bl = scopeChangeRequiresProxy = !this.scoped && nestedScoped;
                if (scopeChangeRequiresProxy) {
                    return BatchScopeSupport.createScopedProxy(beanName, definition, this.registry, this.proxyTargetClass);
                }
            }
            value = super.resolveValue(value);
            return value;
        }
    }
}

