/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class BatchParser
extends AbstractBeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(BatchParser.class);

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        this.parseRefElements(element, registry);
        return null;
    }

    private void parseRefElements(Element element, BeanDefinitionRegistry registry) {
        List beanElements = DomUtils.getChildElementsByTagName((Element)element, (String)"ref");
        if (beanElements.size() > 0) {
            for (Element curElement : beanElements) {
                AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)curElement.getAttribute("class")).getBeanDefinition();
                beanDefinition.setScope("step");
                String beanName = curElement.getAttribute("id");
                if (!registry.containsBeanDefinition(beanName)) {
                    registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
                    continue;
                }
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("Ignoring batch.xml bean definition for " + beanName + " because another bean of the same name has been registered"));
            }
        }
    }
}

