/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.job.flow;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.job.StepHandler;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobFlowExecutor;
import org.springframework.batch.core.repository.JobRepository;

public class JsrFlowExecutor
extends JobFlowExecutor {
    public JsrFlowExecutor(JobRepository jobRepository, StepHandler stepHandler, JobExecution execution) {
        super(jobRepository, stepHandler, execution);
    }

    @Override
    public void addExitStatus(String code) {
        ExitStatus status = new ExitStatus(code);
        if (this.exitStatus != null && ExitStatus.isNonDefaultExitStatus(this.exitStatus) && !ExitStatus.isNonDefaultExitStatus(status)) {
            this.exitStatus = this.exitStatus.and(status);
        }
    }

    @Override
    public void updateJobExecutionStatus(FlowExecutionStatus status) {
        JobExecution execution = super.getJobExecution();
        execution.setStatus(this.findBatchStatus(status));
        ExitStatus curStatus = execution.getExitStatus();
        if (ExitStatus.isNonDefaultExitStatus(curStatus)) {
            this.exitStatus = this.exitStatus.and(new ExitStatus(status.getName()));
            execution.setExitStatus(this.exitStatus);
        } else {
            this.exitStatus = this.exitStatus.and(curStatus);
            execution.setExitStatus(this.exitStatus);
        }
    }
}

