/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.builder;

import java.util.ArrayList;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.step.BatchletStep;
import org.springframework.batch.core.jsr.step.builder.JsrPartitionStepBuilder;
import org.springframework.batch.core.jsr.step.item.JsrChunkProcessor;
import org.springframework.batch.core.jsr.step.item.JsrChunkProvider;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.item.ChunkOrientedTasklet;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;
import org.springframework.util.Assert;

public class JsrSimpleStepBuilder<I, O>
extends SimpleStepBuilder<I, O> {
    private BatchPropertyContext batchPropertyContext;

    public JsrSimpleStepBuilder(StepBuilder parent) {
        super(parent);
    }

    public JsrPartitionStepBuilder partitioner(Step step) {
        return new JsrPartitionStepBuilder(this).step(step);
    }

    public void setBatchPropertyContext(BatchPropertyContext batchPropertyContext) {
        this.batchPropertyContext = batchPropertyContext;
    }

    @Override
    public TaskletStep build() {
        this.registerStepListenerAsItemListener();
        this.registerAsStreamsAndListeners(this.getReader(), this.getProcessor(), this.getWriter());
        this.registerStepListenerAsChunkListener();
        BatchletStep step = new BatchletStep(this.getName(), this.batchPropertyContext);
        super.enhance(step);
        step.setChunkListeners(this.chunkListeners.toArray(new ChunkListener[0]));
        if (this.getTransactionAttribute() != null) {
            step.setTransactionAttribute(this.getTransactionAttribute());
        }
        if (this.getStepOperations() == null) {
            this.stepOperations((RepeatOperations)new RepeatTemplate());
            if (this.getTaskExecutor() != null) {
                TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.getTaskExecutor());
                repeatTemplate.setThrottleLimit(this.getThrottleLimit());
                this.stepOperations((RepeatOperations)repeatTemplate);
            }
            ((RepeatTemplate)this.getStepOperations()).setExceptionHandler(this.getExceptionHandler());
        }
        step.setStepOperations(this.getStepOperations());
        step.setTasklet(this.createTasklet());
        ItemStream[] streams = this.getStreams().toArray(new ItemStream[0]);
        step.setStreams(streams);
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }

    @Override
    protected Tasklet createTasklet() {
        Assert.state((this.getReader() != null ? 1 : 0) != 0, (String)"ItemReader must be provided");
        Assert.state((this.getProcessor() != null || this.getWriter() != null ? 1 : 0) != 0, (String)"ItemWriter or ItemProcessor must be provided");
        RepeatOperations repeatOperations = this.createRepeatOperations();
        JsrChunkProvider chunkProvider = new JsrChunkProvider();
        JsrChunkProcessor chunkProcessor = new JsrChunkProcessor(this.getReader(), this.getProcessor(), this.getWriter(), repeatOperations);
        chunkProcessor.setListeners(new ArrayList<StepListener>(this.getItemListeners()));
        ChunkOrientedTasklet tasklet = new ChunkOrientedTasklet(chunkProvider, chunkProcessor);
        tasklet.setBuffering(!this.isReaderTransactionalQueue());
        return tasklet;
    }

    private RepeatOperations createRepeatOperations() {
        RepeatTemplate repeatOperations = new RepeatTemplate();
        repeatOperations.setCompletionPolicy(this.getChunkCompletionPolicy());
        repeatOperations.setExceptionHandler(this.getExceptionHandler());
        return repeatOperations;
    }
}

