/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.Serializable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JobParameter<T>
implements Serializable {
    private final T value;
    private final Class<T> type;
    private final boolean identifying;

    public JobParameter(@NonNull T value, @NonNull Class<T> type, boolean identifying) {
        Assert.notNull(value, (String)"value must not be null");
        Assert.notNull(type, (String)"type must not be null");
        this.value = value;
        this.type = type;
        this.identifying = identifying;
    }

    public JobParameter(@NonNull T value, @NonNull Class<T> type) {
        this(value, type, true);
    }

    public boolean isIdentifying() {
        return this.identifying;
    }

    public T getValue() {
        return this.value;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobParameter)) {
            return false;
        }
        JobParameter rhs = (JobParameter)obj;
        if (this == obj) {
            return true;
        }
        return this.type == rhs.type && this.value.equals(rhs.value);
    }

    public String toString() {
        return "{value=" + this.value + ", type=" + this.type + ", identifying=" + this.identifying + "}";
    }

    public int hashCode() {
        return 7 + 21 * this.value.hashCode();
    }
}

