/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.builder;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilderHelper;
import org.springframework.batch.core.job.builder.JobFlowBuilder;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.step.builder.StepBuilderException;

public class FlowJobBuilder
extends JobBuilderHelper<FlowJobBuilder> {
    private Flow flow;

    public FlowJobBuilder(JobBuilderHelper<?> parent) {
        super(parent);
    }

    public JobFlowBuilder start(Flow flow) {
        return new JobFlowBuilder(this, flow);
    }

    public JobFlowBuilder start(Step step) {
        return new JobFlowBuilder(this, step);
    }

    public JobFlowBuilder start(JobExecutionDecider decider) {
        return new JobFlowBuilder(this, decider);
    }

    protected FlowJobBuilder flow(Flow flow) {
        this.flow = flow;
        return this;
    }

    public Job build() {
        FlowJob job = new FlowJob();
        job.setName(this.getName());
        job.setFlow(this.flow);
        super.enhance(job);
        try {
            job.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return job;
    }
}

