/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.listener.OrderedComposite;
import org.springframework.lang.Nullable;

public class CompositeItemProcessListener<T, S>
implements ItemProcessListener<T, S> {
    private final OrderedComposite<ItemProcessListener<? super T, ? super S>> listeners = new OrderedComposite();

    public void setListeners(List<? extends ItemProcessListener<? super T, ? super S>> itemProcessorListeners) {
        this.listeners.setItems(itemProcessorListeners);
    }

    public void register(ItemProcessListener<? super T, ? super S> itemProcessorListener) {
        this.listeners.add(itemProcessorListener);
    }

    @Override
    public void afterProcess(T item, @Nullable S result) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.afterProcess(item, result);
        }
    }

    @Override
    public void beforeProcess(T item) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.beforeProcess(item);
        }
    }

    @Override
    public void onProcessError(T item, Exception e) {
        Iterator<ItemProcessListener<T, S>> iterator = this.listeners.reverse();
        while (iterator.hasNext()) {
            ItemProcessListener<T, S> listener = iterator.next();
            listener.onProcessError(item, e);
        }
    }
}

