/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BatchJobObservation implements ObservationDocumentation
{
    BATCH_JOB_OBSERVATION{

        public String getName() {
            return "spring.batch.job";
        }

        public String getContextualName() {
            return "%s";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return JobLowCardinalityTags.values();
        }

        public KeyName[] getHighCardinalityKeyNames() {
            return JobHighCardinalityTags.values();
        }

        public String getPrefix() {
            return "spring.batch";
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum JobHighCardinalityTags implements KeyName
    {
        JOB_INSTANCE_ID{

            public String asString() {
                return "spring.batch.job.instanceId";
            }
        }
        ,
        JOB_EXECUTION_ID{

            public String asString() {
                return "spring.batch.job.executionId";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum JobLowCardinalityTags implements KeyName
    {
        JOB_NAME{

            public String asString() {
                return "spring.batch.job.name";
            }
        }
        ,
        JOB_STATUS{

            public String asString() {
                return "spring.batch.job.status";
            }
        };

    }
}

