/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.TaskExecutorJobLauncher;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.core.step.job.JobStep;

public class JobStepBuilder
extends StepBuilderHelper<JobStepBuilder> {
    private Job job;
    private JobLauncher jobLauncher;
    private JobParametersExtractor jobParametersExtractor;

    public JobStepBuilder(StepBuilderHelper<?> parent) {
        super(parent);
    }

    public JobStepBuilder job(Job job) {
        this.job = job;
        return this;
    }

    public JobStepBuilder launcher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
        return this;
    }

    public JobStepBuilder parametersExtractor(JobParametersExtractor jobParametersExtractor) {
        this.jobParametersExtractor = jobParametersExtractor;
        return this;
    }

    public Step build() {
        JobStep step = new JobStep();
        step.setName(this.getName());
        super.enhance(step);
        if (this.job != null) {
            step.setJob(this.job);
        }
        if (this.jobParametersExtractor != null) {
            step.setJobParametersExtractor(this.jobParametersExtractor);
        }
        if (this.jobLauncher == null) {
            TaskExecutorJobLauncher jobLauncher = new TaskExecutorJobLauncher();
            jobLauncher.setJobRepository(this.getJobRepository());
            try {
                jobLauncher.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new StepBuilderException(e);
            }
            this.jobLauncher = jobLauncher;
        }
        step.setJobLauncher(this.jobLauncher);
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }

    @Override
    protected JobStepBuilder self() {
        return this;
    }
}

