/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.beans.PropertyEditorSupport;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.batch.item.file.transform.Range;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RangeArrayPropertyEditor
extends PropertyEditorSupport {
    private boolean forceDisjointRanges = false;

    public void setForceDisjointRanges(boolean forceDisjointRanges) {
        this.forceDisjointRanges = forceDisjointRanges;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        String[] strRanges = text.split(",");
        Range[] ranges = new Range[strRanges.length];
        int i = 0;
        while (i < strRanges.length) {
            int min;
            String[] range = strRanges[i].split("-");
            if (range.length == 1 && StringUtils.hasText((String)range[0])) {
                min = Integer.parseInt(range[0].trim());
                ranges[i] = new Range(min);
            } else if (range.length == 2 && StringUtils.hasText((String)range[0]) && StringUtils.hasText((String)range[1])) {
                min = Integer.parseInt(range[0].trim());
                int max = Integer.parseInt(range[1].trim());
                ranges[i] = new Range(min, max);
            } else {
                throw new IllegalArgumentException("Range[" + i + "]: range (" + strRanges[i] + ") is invalid");
            }
            ++i;
        }
        this.setMaxValues(ranges);
        this.setValue(ranges);
    }

    public String getAsText() {
        Range[] ranges = (Range[])this.getValue();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < ranges.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(ranges[i]);
            ++i;
        }
        return sb.toString();
    }

    private void setMaxValues(final Range[] ranges) {
        Integer[] c = new Integer[ranges.length];
        int i = 0;
        while (i < c.length) {
            c[i] = i;
            ++i;
        }
        Arrays.sort(c, new Comparator<Integer>(){

            @Override
            public int compare(Integer r1, Integer r2) {
                return ranges[r1].getMin() - ranges[r2].getMin();
            }
        });
        i = 0;
        while (i < c.length - 1) {
            if (!ranges[c[i]].hasMaxValue()) {
                ranges[c[i].intValue()] = new Range(ranges[c[i]].getMin(), ranges[c[i + 1]].getMin() - 1);
            }
            ++i;
        }
        if (this.forceDisjointRanges) {
            this.verifyRanges(ranges);
        }
    }

    private void verifyRanges(Range[] ranges) {
        int i = 1;
        while (i < ranges.length) {
            Assert.isTrue((ranges[i - 1].getMax() < ranges[i].getMin() ? 1 : 0) != 0, (String)("Ranges must be disjoint. Range[" + (i - 1) + "]: (" + ranges[i - 1] + ") Range[" + i + "]: (" + ranges[i] + ")"));
            ++i;
        }
    }
}

