/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParameterUtils {
    public static int countParameterPlaceholders(String sql, List<String> namedParameterHolder) {
        if (sql == null) {
            return 0;
        }
        char[] statement = sql.toCharArray();
        boolean withinQuotes = false;
        HashMap<String, StringBuilder> namedParameters = new HashMap<String, StringBuilder>();
        int currentQuote = 45;
        int parameterCount = 0;
        for (int i = 0; i < statement.length; ++i) {
            if (withinQuotes) {
                if (statement[i] != currentQuote) continue;
                withinQuotes = false;
                currentQuote = 45;
                continue;
            }
            if (statement[i] == '\"' || statement[i] == '\'') {
                withinQuotes = true;
                currentQuote = statement[i];
                continue;
            }
            if (statement[i] == ':' || statement[i] == '&') {
                int j;
                StringBuilder parameter = new StringBuilder();
                for (j = i + 1; j < statement.length && JdbcParameterUtils.parameterNameContinues(statement, j); ++j) {
                    parameter.append(statement[j]);
                }
                if (j - i <= 1 || namedParameters.containsKey(parameter.toString())) continue;
                ++parameterCount;
                namedParameters.put(parameter.toString(), parameter);
                i = j - 1;
                continue;
            }
            if (statement[i] != '?') continue;
            ++parameterCount;
        }
        if (namedParameterHolder != null) {
            namedParameterHolder.addAll(namedParameters.keySet());
        }
        return parameterCount;
    }

    private static boolean parameterNameContinues(char[] statement, int pos) {
        return statement[pos] != ' ' && statement[pos] != ',' && statement[pos] != ')' && statement[pos] != '\"' && statement[pos] != '\'' && statement[pos] != '|' && statement[pos] != ';' && statement[pos] != '\n' && statement[pos] != '\r';
    }
}

