/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.repeat.RepeatStatus;

public class CompositeRepeatListener
implements RepeatListener {
    private List<RepeatListener> listeners = new ArrayList<RepeatListener>();

    public void setListeners(RepeatListener[] listeners) {
        this.listeners = Arrays.asList(listeners);
    }

    public void register(RepeatListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void after(RepeatContext context, RepeatStatus result) {
        for (RepeatListener listener : this.listeners) {
            listener.after(context, result);
        }
    }

    public void before(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.before(context);
        }
    }

    public void close(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.close(context);
        }
    }

    public void onError(RepeatContext context, Throwable e) {
        for (RepeatListener listener : this.listeners) {
            listener.onError(context, e);
        }
    }

    public void open(RepeatContext context) {
        for (RepeatListener listener : this.listeners) {
            listener.open(context);
        }
    }
}

