/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;

public class H2PagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateTopSqlQuery(this, false, this.buildTopClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        return SqlPagingQueryUtils.generateTopSqlQuery(this, true, this.buildTopClause(pageSize));
    }

    private String buildTopClause(int pageSize) {
        return "TOP " + pageSize;
    }

    @Override
    public String generateJumpToItemQuery(int itemIndex, int pageSize) {
        int page = itemIndex / pageSize;
        int offset = page * pageSize - 1;
        offset = offset < 0 ? 0 : offset;
        String topClause = "LIMIT " + offset + " 1";
        return SqlPagingQueryUtils.generateTopJumpToQuery(this, topClause);
    }
}

