/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.endpoint;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.endpoint.FrameworkEndpoint;
import org.springframework.security.oauth2.provider.endpoint.SpelView;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.util.HtmlUtils;

@FrameworkEndpoint
public class WhitelabelErrorEndpoint {
    private static final String ERROR = "<html><body><h1>OAuth Error</h1><p>${errorSummary}</p></body></html>";

    @RequestMapping(value={"/oauth/error"})
    public ModelAndView handleError(HttpServletRequest request) {
        String errorSummary;
        HashMap<String, String> model = new HashMap<String, String>();
        Object error = request.getAttribute("error");
        if (error instanceof OAuth2Exception) {
            OAuth2Exception oauthError = (OAuth2Exception)error;
            errorSummary = HtmlUtils.htmlEscape((String)oauthError.getSummary());
        } else {
            errorSummary = "Unknown error";
        }
        model.put("errorSummary", errorSummary);
        return new ModelAndView((View)new SpelView(ERROR), model);
    }
}

