/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.builders;

import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.builders.ClientDetailsServiceBuilder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.util.Assert;

public class JdbcClientDetailsServiceBuilder
extends ClientDetailsServiceBuilder<JdbcClientDetailsServiceBuilder> {
    private Set<ClientDetails> clientDetails = new HashSet<ClientDetails>();
    private DataSource dataSource;
    private PasswordEncoder passwordEncoder;

    public JdbcClientDetailsServiceBuilder dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JdbcClientDetailsServiceBuilder passwordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
        return this;
    }

    @Override
    protected void addClient(String clientId, ClientDetails value) {
        this.clientDetails.add(value);
    }

    @Override
    protected ClientDetailsService performBuild() {
        Assert.state((this.dataSource != null ? 1 : 0) != 0, (String)"You need to provide a DataSource");
        JdbcClientDetailsService clientDetailsService = new JdbcClientDetailsService(this.dataSource);
        if (this.passwordEncoder != null) {
            clientDetailsService.setPasswordEncoder(this.passwordEncoder);
        }
        for (ClientDetails client : this.clientDetails) {
            clientDetailsService.addClientDetails(client);
        }
        return clientDetailsService;
    }
}

