/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.mime;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.mime.AttachmentException;
import org.springframework.ws.mime.MimeMessage;

public abstract class AbstractMimeMessage
implements MimeMessage {
    @Override
    public final Attachment addAttachment(String contentId, File file) throws AttachmentException {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)file, (String)"File must not be null");
        DataHandler dataHandler = new DataHandler((DataSource)new FileDataSource(file));
        return this.addAttachment(contentId, dataHandler);
    }

    @Override
    public final Attachment addAttachment(String contentId, InputStreamSource inputStreamSource, String contentType) {
        Assert.hasLength((String)contentId, (String)"contentId must not be empty");
        Assert.notNull((Object)inputStreamSource, (String)"InputStreamSource must not be null");
        if (inputStreamSource instanceof Resource && ((Resource)inputStreamSource).isOpen()) {
            throw new IllegalArgumentException("Passed-in Resource contains an open stream: invalid argument. MIME requires an InputStreamSource that creates a fresh stream for every call.");
        }
        DataHandler dataHandler = new DataHandler((DataSource)new InputStreamSourceDataSource(inputStreamSource, contentType));
        return this.addAttachment(contentId, dataHandler);
    }

    private static class InputStreamSourceDataSource
    implements DataSource {
        private final InputStreamSource inputStreamSource;
        private final String contentType;

        public InputStreamSourceDataSource(InputStreamSource inputStreamSource, String contentType) {
            this.inputStreamSource = inputStreamSource;
            this.contentType = contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStreamSource.getInputStream();
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Read-only jakarta.activation.DataSource");
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getName() {
            if (this.inputStreamSource instanceof Resource) {
                Resource resource = (Resource)this.inputStreamSource;
                return resource.getFilename();
            }
            throw new UnsupportedOperationException("DataSource name not available");
        }
    }
}

