/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.converters.DOMConverter;
import org.springframework.core.NestedRuntimeException;
import org.springframework.ws.server.endpoint.PayloadEndpoint;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.transform.TraxUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

@Deprecated
public abstract class AbstractXomPayloadEndpoint
extends TransformerObjectSupport
implements PayloadEndpoint {
    @Override
    public final Source invoke(Source request) throws Exception {
        nu.xom.Element responseElement;
        nu.xom.Element requestElement = null;
        if (request != null) {
            XomSourceCallback sourceCallback = new XomSourceCallback();
            try {
                TraxUtils.doWithSource((Source)request, (TraxUtils.SourceCallback)sourceCallback);
            }
            catch (XomParsingException ex) {
                throw (ParsingException)ex.getCause();
            }
            requestElement = sourceCallback.element;
        }
        return (responseElement = this.invokeInternal(requestElement)) != null ? this.convertResponse(responseElement) : null;
    }

    private Source convertResponse(nu.xom.Element responseElement) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Serializer serializer = this.createSerializer(os);
        Document document = responseElement.getDocument();
        if (document == null) {
            document = new Document(responseElement);
        }
        serializer.write(document);
        byte[] bytes = os.toByteArray();
        return new StreamSource(new ByteArrayInputStream(bytes));
    }

    protected Serializer createSerializer(OutputStream outputStream) {
        return new Serializer(outputStream);
    }

    protected abstract nu.xom.Element invokeInternal(nu.xom.Element var1) throws Exception;

    private static class XomSourceCallback
    implements TraxUtils.SourceCallback {
        private nu.xom.Element element;

        private XomSourceCallback() {
        }

        public void domSource(org.w3c.dom.Node node) {
            if (node.getNodeType() == 1) {
                this.element = DOMConverter.convert((Element)((Element)node));
            } else if (node.getNodeType() == 9) {
                Document document = DOMConverter.convert((org.w3c.dom.Document)((org.w3c.dom.Document)node));
                this.element = document.getRootElement();
            } else {
                throw new IllegalArgumentException("DOMSource contains neither Document nor Element");
            }
        }

        public void saxSource(XMLReader reader, InputSource inputSource) throws IOException, SAXException {
            try {
                Document document;
                Builder builder = new Builder(reader);
                if (inputSource.getByteStream() != null) {
                    document = builder.build(inputSource.getByteStream());
                } else if (inputSource.getCharacterStream() != null) {
                    document = builder.build(inputSource.getCharacterStream());
                } else {
                    throw new IllegalArgumentException("InputSource in SAXSource contains neither byte stream nor character stream");
                }
                this.element = document.getRootElement();
            }
            catch (ParsingException e) {
                throw new XomParsingException(e);
            }
        }

        public void staxSource(XMLEventReader eventReader) throws XMLStreamException {
            throw new IllegalArgumentException("XMLEventReader not supported");
        }

        public void staxSource(XMLStreamReader streamReader) throws XMLStreamException {
            Document document = StaxStreamConverter.convert(streamReader);
            this.element = document.getRootElement();
        }

        public void streamSource(InputStream inputStream) throws IOException {
            try {
                Builder builder = new Builder();
                Document document = builder.build(inputStream);
                this.element = document.getRootElement();
            }
            catch (ParsingException ex) {
                throw new XomParsingException(ex);
            }
        }

        public void streamSource(Reader reader) throws IOException {
            try {
                Builder builder = new Builder();
                Document document = builder.build(reader);
                this.element = document.getRootElement();
            }
            catch (ParsingException ex) {
                throw new XomParsingException(ex);
            }
        }

        public void source(String systemId) throws Exception {
            try {
                Builder builder = new Builder();
                Document document = builder.build(systemId);
                this.element = document.getRootElement();
            }
            catch (ParsingException ex) {
                throw new XomParsingException(ex);
            }
        }
    }

    private static class XomParsingException
    extends NestedRuntimeException {
        private XomParsingException(ParsingException ex) {
            super(ex.getMessage(), (Throwable)ex);
        }
    }

    private static class StaxStreamConverter {
        private StaxStreamConverter() {
        }

        private static Document convert(XMLStreamReader streamReader) throws XMLStreamException {
            NodeFactory nodeFactory = new NodeFactory();
            Document document = null;
            nu.xom.Element element = null;
            Document parent = null;
            boolean documentFinished = false;
            while (streamReader.hasNext()) {
                int event = streamReader.next();
                switch (event) {
                    case 7: {
                        parent = document = nodeFactory.startMakingDocument();
                        break;
                    }
                    case 8: {
                        nodeFactory.finishMakingDocument(document);
                        documentFinished = true;
                        break;
                    }
                    case 1: {
                        if (document == null) {
                            parent = document = nodeFactory.startMakingDocument();
                        }
                        String name = QNameUtils.toQualifiedName((QName)streamReader.getName());
                        if (element == null) {
                            element = nodeFactory.makeRootElement(name, streamReader.getNamespaceURI());
                            document.setRootElement(element);
                        } else {
                            element = nodeFactory.startMakingElement(name, streamReader.getNamespaceURI());
                            parent.appendChild((Node)element);
                        }
                        StaxStreamConverter.convertNamespaces(streamReader, element);
                        StaxStreamConverter.convertAttributes(streamReader, nodeFactory);
                        parent = element;
                        break;
                    }
                    case 2: {
                        nodeFactory.finishMakingElement(element);
                        parent = parent.getParent();
                        break;
                    }
                    case 10: {
                        StaxStreamConverter.convertAttributes(streamReader, nodeFactory);
                        break;
                    }
                    case 4: {
                        nodeFactory.makeText(streamReader.getText());
                        break;
                    }
                    case 5: {
                        nodeFactory.makeComment(streamReader.getText());
                        break;
                    }
                }
            }
            if (!documentFinished) {
                nodeFactory.finishMakingDocument(document);
            }
            return document;
        }

        private static void convertNamespaces(XMLStreamReader streamReader, nu.xom.Element element) {
            for (int i = 0; i < streamReader.getNamespaceCount(); ++i) {
                String uri = streamReader.getNamespaceURI(i);
                String prefix = streamReader.getNamespacePrefix(i);
                element.addNamespaceDeclaration(prefix, uri);
            }
        }

        private static void convertAttributes(XMLStreamReader streamReader, NodeFactory nodeFactory) {
            for (int i = 0; i < streamReader.getAttributeCount(); ++i) {
                String name = QNameUtils.toQualifiedName((QName)streamReader.getAttributeName(i));
                String uri = streamReader.getAttributeNamespace(i);
                String value = streamReader.getAttributeValue(i);
                Attribute.Type type = StaxStreamConverter.convertAttributeType(streamReader.getAttributeType(i));
                nodeFactory.makeAttribute(name, uri, value, type);
            }
        }

        private static Attribute.Type convertAttributeType(String type) {
            if ("CDATA".equals(type = type.toUpperCase(Locale.ENGLISH))) {
                return Attribute.Type.CDATA;
            }
            if ("ENTITIES".equals(type)) {
                return Attribute.Type.ENTITIES;
            }
            if ("ENTITY".equals(type)) {
                return Attribute.Type.ENTITY;
            }
            if ("ENUMERATION".equals(type)) {
                return Attribute.Type.ENUMERATION;
            }
            if ("ID".equals(type)) {
                return Attribute.Type.ID;
            }
            if ("IDREF".equals(type)) {
                return Attribute.Type.IDREF;
            }
            if ("IDREFS".equals(type)) {
                return Attribute.Type.IDREFS;
            }
            if ("NMTOKEN".equals(type)) {
                return Attribute.Type.NMTOKEN;
            }
            if ("NMTOKENS".equals(type)) {
                return Attribute.Type.NMTOKENS;
            }
            if ("NOTATION".equals(type)) {
                return Attribute.Type.NOTATION;
            }
            return Attribute.Type.UNDECLARED;
        }
    }
}

