/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.addressing.version;

import java.net.URI;
import javax.xml.namespace.QName;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.EndpointReference;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.version.AbstractAddressingVersion;

public class Addressing200408
extends AbstractAddressingVersion {
    private static final String NAMESPACE_URI = "http://schemas.xmlsoap.org/ws/2004/08/addressing";

    @Override
    public void addAddressingHeaders(SoapMessage message, MessageAddressingProperties map) {
        Assert.notNull((Object)map.getAction(), (String)"'Action' is required");
        Assert.notNull((Object)map.getTo(), (String)"'To' is required");
        super.addAddressingHeaders(message, map);
    }

    @Override
    public boolean hasRequiredProperties(MessageAddressingProperties map) {
        if (map.getTo() == null) {
            return false;
        }
        if (map.getAction() == null) {
            return false;
        }
        if (map.getReplyTo() != null || map.getFaultTo() != null) {
            return map.getMessageId() != null;
        }
        return true;
    }

    @Override
    public boolean isToHeaderRequired() {
        return true;
    }

    @Override
    protected final URI getAnonymous() {
        return URI.create("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous");
    }

    @Override
    protected final String getInvalidAddressingHeaderFaultReason() {
        return "A message information header is not valid and the message cannot be processed.";
    }

    @Override
    protected final QName getInvalidAddressingHeaderFaultSubcode() {
        return new QName(NAMESPACE_URI, "InvalidMessageInformationHeader", this.getNamespacePrefix());
    }

    @Override
    protected final String getMessageAddressingHeaderRequiredFaultReason() {
        return "A required message information header, To, MessageID, or Action, is not present.";
    }

    @Override
    protected final QName getMessageAddressingHeaderRequiredFaultSubcode() {
        return new QName(NAMESPACE_URI, "MessageInformationHeaderRequired", this.getNamespacePrefix());
    }

    @Override
    protected final String getNamespaceUri() {
        return NAMESPACE_URI;
    }

    @Override
    protected URI getDefaultTo() {
        return null;
    }

    @Override
    protected final EndpointReference getDefaultReplyTo(EndpointReference from) {
        return from;
    }

    @Override
    protected final URI getNone() {
        return null;
    }

    public String toString() {
        return "WS-Addressing August 2004";
    }
}

