/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.saaj.support;

import jakarta.xml.soap.Name;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.Text;
import java.util.Iterator;
import org.springframework.util.StringUtils;
import org.springframework.xml.sax.AbstractXmlReader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class SaajXmlReader
extends AbstractXmlReader {
    private static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_NAME = "http://xml.org/sax/features/namespace-prefixes";
    private final Node startNode;
    private boolean namespacesFeature = true;
    private boolean namespacePrefixesFeature = false;

    public SaajXmlReader(Node startNode) {
        this.startNode = startNode;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            return this.namespacesFeature;
        }
        if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            return this.namespacePrefixesFeature;
        }
        return super.getFeature(name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (NAMESPACES_FEATURE_NAME.equals(name)) {
            this.namespacesFeature = value;
        } else if (NAMESPACE_PREFIXES_FEATURE_NAME.equals(name)) {
            this.namespacePrefixesFeature = value;
        } else {
            super.setFeature(name, value);
        }
    }

    public final void parse(InputSource ignored) throws SAXException {
        this.parse();
    }

    public final void parse(String ignored) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        if (this.getContentHandler() != null) {
            this.getContentHandler().startDocument();
        }
        this.handleNode(this.startNode);
        if (this.getContentHandler() != null) {
            this.getContentHandler().endDocument();
        }
    }

    private void handleNode(Node node) throws SAXException {
        if (node instanceof SOAPElement) {
            this.handleElement((SOAPElement)node);
        } else if (node instanceof Text) {
            Text text = (Text)node;
            this.handleText(text);
        }
    }

    private void handleElement(SOAPElement element) throws SAXException {
        String prefix;
        Iterator iterator;
        Name elementName = element.getElementName();
        if (this.getContentHandler() != null) {
            if (this.namespacesFeature) {
                iterator = element.getNamespacePrefixes();
                while (iterator.hasNext()) {
                    prefix = (String)iterator.next();
                    String namespaceUri = element.getNamespaceURI(prefix);
                    this.getContentHandler().startPrefixMapping(prefix, namespaceUri);
                }
                this.getContentHandler().startElement(elementName.getURI(), elementName.getLocalName(), elementName.getQualifiedName(), this.getAttributes(element));
            } else {
                this.getContentHandler().startElement("", "", elementName.getQualifiedName(), this.getAttributes(element));
            }
        }
        iterator = element.getChildElements();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            this.handleNode(child);
        }
        if (this.getContentHandler() != null) {
            if (this.namespacesFeature) {
                this.getContentHandler().endElement(elementName.getURI(), elementName.getLocalName(), elementName.getQualifiedName());
                iterator = element.getNamespacePrefixes();
                while (iterator.hasNext()) {
                    prefix = (String)iterator.next();
                    this.getContentHandler().endPrefixMapping(prefix);
                }
            } else {
                this.getContentHandler().endElement("", "", elementName.getQualifiedName());
            }
        }
    }

    private void handleText(Text text) throws SAXException {
        if (this.getContentHandler() != null) {
            char[] ch = text.getValue() != null ? text.getValue().toCharArray() : new char[]{};
            this.getContentHandler().characters(ch, 0, ch.length);
        }
    }

    private Attributes getAttributes(SOAPElement element) {
        AttributesImpl attributes = new AttributesImpl();
        Iterator iterator = element.getAllAttributes();
        while (iterator.hasNext()) {
            Name attributeName = (Name)iterator.next();
            String namespace = attributeName.getURI();
            if (namespace == null || !this.namespacesFeature) {
                namespace = "";
            }
            String attributeValue = element.getAttributeValue(attributeName);
            attributes.addAttribute(namespace, attributeName.getLocalName(), attributeName.getQualifiedName(), "CDATA", attributeValue);
        }
        if (this.namespacePrefixesFeature) {
            iterator = element.getNamespacePrefixes();
            while (iterator.hasNext()) {
                String prefix = (String)iterator.next();
                String namespaceUri = element.getNamespaceURI(prefix);
                Object qName = StringUtils.hasLength((String)prefix) ? "xmlns:" + prefix : "xmlns";
                attributes.addAttribute("", "", (String)qName, "CDATA", namespaceUri);
            }
        }
        return attributes;
    }
}

