/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint;

import java.beans.PropertyEditorSupport;
import java.util.Locale;
import javax.xml.namespace.QName;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.xml.namespace.QNameEditor;

public class SoapFaultDefinitionEditor
extends PropertyEditorSupport {
    private static final int FAULT_CODE_INDEX = 0;
    private static final int FAULT_STRING_INDEX = 1;
    private static final int FAULT_STRING_LOCALE_INDEX = 2;

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasLength((String)text)) {
            this.setValue(null);
        } else {
            String[] tokens = StringUtils.commaDelimitedListToStringArray((String)text);
            if (tokens.length < 1) {
                throw new IllegalArgumentException("Invalid amount of comma delimited values in [" + text + "]: SoapFaultDefinitionEditor requires at least 1");
            }
            SoapFaultDefinition definition = new SoapFaultDefinition();
            QNameEditor qNameEditor = new QNameEditor();
            qNameEditor.setAsText(tokens[0].trim());
            definition.setFaultCode((QName)qNameEditor.getValue());
            if (tokens.length > 1) {
                definition.setFaultStringOrReason(tokens[1].trim());
                if (tokens.length > 2) {
                    LocaleEditor localeEditor = new LocaleEditor();
                    localeEditor.setAsText(tokens[2].trim());
                    definition.setLocale((Locale)localeEditor.getValue());
                }
            }
            this.setValue(definition);
        }
    }
}

