/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.server.endpoint.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;
import org.springframework.ws.server.EndpointInvocationChain;
import org.springframework.ws.server.endpoint.mapping.AbstractAnnotationMethodEndpointMapping;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.SoapEndpointInvocationChain;
import org.springframework.ws.soap.server.SoapEndpointMapping;
import org.springframework.ws.soap.server.endpoint.annotation.SoapAction;
import org.springframework.ws.soap.server.endpoint.annotation.SoapActions;

public class SoapActionAnnotationMethodEndpointMapping
extends AbstractAnnotationMethodEndpointMapping<String>
implements SoapEndpointMapping {
    private String[] actorsOrRoles;
    private boolean isUltimateReceiver = true;

    @Override
    public final void setActorOrRole(String actorOrRole) {
        Assert.notNull((Object)actorOrRole, (String)"actorOrRole must not be null");
        this.actorsOrRoles = new String[]{actorOrRole};
    }

    @Override
    public final void setActorsOrRoles(String[] actorsOrRoles) {
        Assert.notEmpty((Object[])actorsOrRoles, (String)"actorsOrRoles must not be empty");
        this.actorsOrRoles = actorsOrRoles;
    }

    @Override
    public final void setUltimateReceiver(boolean ultimateReceiver) {
        this.isUltimateReceiver = ultimateReceiver;
    }

    @Override
    protected final EndpointInvocationChain createEndpointInvocationChain(MessageContext messageContext, Object endpoint, EndpointInterceptor[] interceptors) {
        return new SoapEndpointInvocationChain(endpoint, interceptors, this.actorsOrRoles, this.isUltimateReceiver);
    }

    @Override
    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        if (messageContext.getRequest() instanceof SoapMessage) {
            SoapMessage request = (SoapMessage)messageContext.getRequest();
            String soapAction = request.getSoapAction();
            if (StringUtils.hasLength((String)soapAction) && soapAction.charAt(0) == '\"' && soapAction.charAt(soapAction.length() - 1) == '\"') {
                return soapAction.substring(1, soapAction.length() - 1);
            }
            return soapAction;
        }
        return null;
    }

    @Override
    protected String getLookupKeyForMethod(Method method) {
        SoapAction soapAction = (SoapAction)AnnotationUtils.findAnnotation((Method)method, SoapAction.class);
        return soapAction != null ? soapAction.value() : null;
    }

    @Override
    protected List<String> getLookupKeysForMethod(Method method) {
        ArrayList<String> result = new ArrayList<String>();
        SoapActions soapActions = (SoapActions)AnnotationUtils.findAnnotation((Method)method, SoapActions.class);
        if (soapActions != null) {
            for (SoapAction soapAction : soapActions.value()) {
                result.add(soapAction.value());
            }
        } else {
            SoapAction soapAction = (SoapAction)AnnotationUtils.findAnnotation((Method)method, SoapAction.class);
            if (soapAction != null) {
                result.add(soapAction.value());
            }
        }
        return result;
    }
}

