/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.Timeout;
import org.springframework.beans.factory.FactoryBean;

public class HttpComponents5ClientFactory
implements FactoryBean<CloseableHttpClient> {
    public static final AuthScope ANY = new AuthScope(null, null, -1, null, null);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private Duration readTimeout = DEFAULT_READ_TIMEOUT;
    private int maxTotalConnections = -1;
    private AuthScope authScope = ANY;
    private Credentials credentials = null;
    private Map<String, String> maxConnectionsPerHost = Map.of();
    private PoolingHttpClientConnectionManager connectionManager;
    private HttpClientBuilderCustomizer clientBuilderCustomizer;
    private PoolingHttpClientConnectionManagerBuilderCustomizer connectionManagerBuilderCustomizer;

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setAuthScope(AuthScope authScope) {
        this.authScope = authScope;
    }

    public void setConnectionTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.connectionTimeout = timeout;
    }

    public void setReadTimeout(Duration timeout) {
        if (timeout.isNegative()) {
            throw new IllegalArgumentException("timeout must be a non-negative value");
        }
        this.readTimeout = timeout;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        if (maxTotalConnections <= 0) {
            throw new IllegalArgumentException("maxTotalConnections must be a positive value");
        }
        this.maxTotalConnections = maxTotalConnections;
    }

    public void setMaxConnectionsPerHost(Map<String, String> maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
    }

    void applyMaxConnectionsPerHost(PoolingHttpClientConnectionManager connectionManager) throws URISyntaxException {
        for (Map.Entry<String, String> entry : this.maxConnectionsPerHost.entrySet()) {
            URI uri = new URI(entry.getKey());
            HttpHost host = new HttpHost(uri.getScheme(), uri.getHost(), HttpComponents5ClientFactory.getPort(uri));
            HttpRoute route = uri.getScheme().equals("https") ? new HttpRoute(host, null, true) : new HttpRoute(host);
            int max = Integer.parseInt(entry.getValue());
            connectionManager.setMaxPerRoute(route, max);
        }
    }

    static int getPort(URI uri) {
        if (uri.getPort() == -1) {
            if ("https".equalsIgnoreCase(uri.getScheme())) {
                return 443;
            }
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                return 80;
            }
        }
        return uri.getPort();
    }

    public boolean isSingleton() {
        return true;
    }

    public CloseableHttpClient getObject() throws Exception {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (this.maxTotalConnections != -1) {
            connectionManagerBuilder.setMaxConnTotal(this.maxTotalConnections);
        }
        if (this.connectionManagerBuilderCustomizer != null) {
            this.connectionManagerBuilderCustomizer.customize(connectionManagerBuilder);
        }
        this.connectionManager = connectionManagerBuilder.build();
        this.applyMaxConnectionsPerHost(this.connectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(Timeout.of((Duration)this.connectionTimeout)).setResponseTimeout(Timeout.of((Duration)this.readTimeout));
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.credentials != null && this.authScope != null) {
            BasicCredentialsProvider basicCredentialsProvider = new BasicCredentialsProvider();
            basicCredentialsProvider.setCredentials(this.authScope, this.credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredentialsProvider);
        }
        if (this.clientBuilderCustomizer != null) {
            this.clientBuilderCustomizer.customize(httpClientBuilder);
        }
        return httpClientBuilder.build();
    }

    public Class<?> getObjectType() {
        return CloseableHttpClient.class;
    }

    PoolingHttpClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void setClientBuilderCustomizer(HttpClientBuilderCustomizer clientBuilderCustomizer) {
        this.clientBuilderCustomizer = clientBuilderCustomizer;
    }

    public void setConnectionManagerBuilderCustomizer(PoolingHttpClientConnectionManagerBuilderCustomizer connectionManagerBuilderCustomizer) {
        this.connectionManagerBuilderCustomizer = connectionManagerBuilderCustomizer;
    }

    @FunctionalInterface
    public static interface PoolingHttpClientConnectionManagerBuilderCustomizer {
        public void customize(PoolingHttpClientConnectionManagerBuilder var1);
    }

    @FunctionalInterface
    public static interface HttpClientBuilderCustomizer {
        public void customize(HttpClientBuilder var1);
    }
}

