/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class HttpComponents5Connection
extends AbstractHttpSenderConnection {
    private final HttpClient httpClient;
    private final HttpPost httpPost;
    private final HttpContext httpContext;
    private HttpResponse httpResponse;
    private ByteArrayOutputStream requestBuffer;

    protected HttpComponents5Connection(HttpClient httpClient, HttpPost httpPost, HttpContext httpContext) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        Assert.notNull((Object)httpPost, (String)"httpPost must not be null");
        this.httpClient = httpClient;
        this.httpPost = httpPost;
        this.httpContext = httpContext;
    }

    public HttpPost getHttpPost() {
        return this.httpPost;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public void onClose() throws IOException {
        ClassicHttpResponse response;
        HttpResponse httpResponse = this.httpResponse;
        if (httpResponse instanceof ClassicHttpResponse && (response = (ClassicHttpResponse)httpResponse).getEntity() != null) {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return new URI(this.httpPost.getUri().toString());
    }

    @Override
    protected void onSendBeforeWrite(WebServiceMessage message) throws IOException {
        this.requestBuffer = new ByteArrayOutputStream();
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        this.httpPost.addHeader(name, (Object)value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.requestBuffer;
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        String contentType = this.httpPost.getFirstHeader("Content-Type").getValue();
        this.httpPost.setEntity((HttpEntity)new ByteArrayEntity(this.requestBuffer.toByteArray(), ContentType.parse((CharSequence)contentType)));
        this.requestBuffer = null;
        this.httpResponse = this.httpContext != null ? this.httpClient.execute((ClassicHttpRequest)this.httpPost, this.httpContext) : this.httpClient.execute((ClassicHttpRequest)this.httpPost);
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.httpResponse.getCode();
    }

    @Override
    protected String getResponseMessage() throws IOException {
        return this.httpResponse.getReasonPhrase();
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        ClassicHttpResponse response;
        HttpEntity entity;
        HttpResponse httpResponse = this.httpResponse;
        if (httpResponse instanceof ClassicHttpResponse && (entity = (response = (ClassicHttpResponse)httpResponse).getEntity()) != null) {
            return entity.getContentLength();
        }
        return 0L;
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        ClassicHttpResponse response;
        HttpEntity entity;
        HttpResponse httpResponse = this.httpResponse;
        if (httpResponse instanceof ClassicHttpResponse && (entity = (response = (ClassicHttpResponse)httpResponse).getEntity()) != null) {
            return entity.getContent();
        }
        throw new IllegalStateException("Response has no enclosing response entity, cannot create input stream");
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        return Arrays.stream(this.httpResponse.getHeaders()).map(NameValuePair::getName).iterator();
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        return Arrays.stream(this.httpResponse.getHeaders(name)).map(NameValuePair::getValue).iterator();
    }
}

