/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.http.AbstractHttpWebServiceMessageSender;
import org.springframework.ws.transport.http.HttpComponents5ClientFactory;
import org.springframework.ws.transport.http.HttpComponents5Connection;

public class HttpComponents5MessageSender
extends AbstractHttpWebServiceMessageSender
implements InitializingBean,
DisposableBean {
    private static final String HTTP_CLIENT_ALREADY_SET = "httpClient already set";
    private HttpClient httpClient;
    private HttpComponents5ClientFactory clientFactory;

    public HttpComponents5MessageSender() {
        this.clientFactory = new HttpComponents5ClientFactory();
        this.clientFactory.setClientBuilderCustomizer(httpClientBuilder -> httpClientBuilder.addRequestInterceptorFirst((HttpRequestInterceptor)new RemoveSoapHeadersInterceptor()));
    }

    public HttpComponents5MessageSender(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"httpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setAuthScope(AuthScope authScope) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setAuthScope(authScope);
    }

    public void setCredentials(Credentials credentials) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setCredentials(credentials);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void setConnectionTimeout(Duration timeout) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setConnectionTimeout(timeout);
    }

    public void setReadTimeout(Duration timeout) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setReadTimeout(timeout);
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setMaxTotalConnections(maxTotalConnections);
    }

    public void setMaxConnectionsPerHost(Map<String, String> maxConnectionsPerHost) {
        if (this.getHttpClient() != null) {
            throw new IllegalStateException(HTTP_CLIENT_ALREADY_SET);
        }
        this.clientFactory.setMaxConnectionsPerHost(maxConnectionsPerHost);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.clientFactory != null) {
            this.httpClient = this.clientFactory.getObject();
        }
    }

    @Override
    public WebServiceConnection createConnection(URI uri) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.isAcceptGzipEncoding()) {
            httpPost.addHeader("Accept-Encoding", (Object)"gzip");
        }
        HttpContext httpContext = this.createContext(uri);
        return new HttpComponents5Connection(this.getHttpClient(), httpPost, httpContext);
    }

    protected HttpContext createContext(URI uri) {
        return null;
    }

    public void destroy() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient instanceof CloseableHttpClient) {
            CloseableHttpClient client = (CloseableHttpClient)httpClient;
            client.close();
        }
    }

    public static class RemoveSoapHeadersInterceptor
    implements HttpRequestInterceptor {
        public void process(HttpRequest request, EntityDetails entityDetails, HttpContext httpContext) throws HttpException, IOException {
            if (request.containsHeader("Transfer-Encoding")) {
                request.removeHeaders("Transfer-Encoding");
            }
            if (request.containsHeader("Content-Length")) {
                request.removeHeaders("Content-Length");
            }
        }
    }
}

