/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.springframework.xml.xpath.XPathExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class LocationTransformerObjectSupport
extends TransformerObjectSupport {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected void transformLocations(XPathExpression xPathExpression, Document definitionDocument, HttpServletRequest request) {
        Assert.notNull((Object)xPathExpression, (String)"'xPathExpression' must not be null");
        Assert.notNull((Object)definitionDocument, (String)"'definitionDocument' must not be null");
        Assert.notNull((Object)request, (String)"'request' must not be null");
        List locationNodes = xPathExpression.evaluateAsNodeList((Node)definitionDocument);
        for (Node locationNode : locationNodes) {
            Attr location;
            if (!(locationNode instanceof Attr) || !StringUtils.hasLength((String)(location = (Attr)locationNode).getValue())) continue;
            String newLocation = this.transformLocation(location.getValue(), request);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Transforming [" + location.getValue() + "] to [" + newLocation + "]"));
            }
            location.setValue(newLocation);
        }
    }

    protected String transformLocation(String location, HttpServletRequest request) {
        String xForwardedProto = request.getHeader("X-Forwarded-Proto");
        String xForwardedHost = request.getHeader("X-Forwarded-Host");
        String xForwardedPort = request.getHeader("X-Forwarded-Port");
        String scheme = StringUtils.hasText((String)xForwardedProto) ? xForwardedProto : request.getScheme();
        String serverName = StringUtils.hasText((String)xForwardedHost) ? xForwardedHost : request.getServerName();
        int serverPort = StringUtils.hasText((String)xForwardedPort) ? Integer.parseInt(xForwardedPort) : request.getServerPort();
        StringBuilder url = new StringBuilder(scheme);
        url.append("://").append(serverName).append(':').append(serverPort);
        if (location.startsWith("/")) {
            url.append(request.getContextPath()).append(location);
            return url.toString();
        }
        int idx = location.indexOf("://");
        if (idx != -1 && (idx = location.indexOf(47, idx + 3)) != -1) {
            String path = location.substring(idx);
            url.append(path);
            return url.toString();
        }
        return location;
    }
}

