/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.context.VariablesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WrappingVariablesMap<K, V>
extends VariablesMap<K, V> {
    private static final long serialVersionUID = 5894245538819382467L;
    private final VariablesMap<K, V> targetMap;
    private HashSet<K> targetRemovedKeys;

    WrappingVariablesMap(VariablesMap<K, V> targetMap) {
        this.targetMap = targetMap;
    }

    @Override
    public int size() {
        return super.size() + this.targetMap.size() - (this.targetRemovedKeys == null ? 0 : this.targetRemovedKeys.size());
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.targetMap.isEmpty() || this.targetRemovedKeys != null && this.targetRemovedKeys.size() == this.targetMap.size());
    }

    @Override
    public boolean containsKey(Object key) {
        if (super.containsKey(key)) {
            return true;
        }
        if (this.containsRemovedKey(key)) {
            return false;
        }
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        if (this.targetRemovedKeys == null) {
            return this.targetMap.containsValue(value);
        }
        for (Map.Entry targetEntry : this.targetMap.entrySet()) {
            if (this.containsRemovedKey(targetEntry.getKey()) || !(value == null ? targetEntry.getValue() == null : value.equals(targetEntry.getValue()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (super.containsKey(key)) {
            return super.get(key);
        }
        if (this.containsRemovedKey(key)) {
            return null;
        }
        return this.targetMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        V oldValue = super.put(key, value);
        if (oldValue == null && this.targetMap.containsKey(key)) {
            if (this.targetRemovedKeys == null) {
                this.targetRemovedKeys = new HashSet(3);
            } else if (!this.targetRemovedKeys.contains(key)) {
                oldValue = this.targetMap.get(key);
            }
            this.targetRemovedKeys.add(key);
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        if (super.containsKey(key)) {
            return super.remove(key);
        }
        if (this.containsRemovedKey(key)) {
            return null;
        }
        if (this.targetMap.containsKey(key)) {
            if (this.targetRemovedKeys == null) {
                this.targetRemovedKeys = new HashSet(3);
            }
            if (this.targetRemovedKeys.add(key)) {
                return this.targetMap.get(key);
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.targetRemovedKeys = new HashSet(this.targetMap.keySet());
        super.clear();
    }

    @Override
    public Set<K> keySet() {
        Set targetKeySet = this.targetMap.keySet();
        if (targetKeySet.isEmpty()) {
            return super.keySet();
        }
        HashSet keySet = new HashSet(targetKeySet);
        if (this.targetRemovedKeys != null) {
            keySet.removeAll(this.targetRemovedKeys);
        }
        keySet.addAll(super.keySet());
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> values;
        if (this.targetMap.isEmpty()) {
            return super.values();
        }
        if (this.targetRemovedKeys == null) {
            values = new ArrayList(this.targetMap.values());
        } else {
            Set targetEntrySet = this.targetMap.entrySet();
            values = new ArrayList(targetEntrySet.size() + super.size() - this.targetRemovedKeys.size());
            for (Map.Entry targetEntry : targetEntrySet) {
                if (this.targetRemovedKeys.contains(targetEntry.getKey())) continue;
                values.add(targetEntry.getValue());
            }
        }
        values.addAll(super.values());
        return Collections.unmodifiableCollection(values);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set entrySet;
        if (this.targetRemovedKeys == null) {
            entrySet = new HashSet(this.targetMap.entrySet());
        } else {
            HashMap<K, V> targetMapCopy = new HashMap<K, V>(this.targetMap);
            targetMapCopy.keySet().removeAll(this.targetRemovedKeys);
            entrySet = targetMapCopy.entrySet();
        }
        if (entrySet.isEmpty()) {
            return super.entrySet();
        }
        entrySet.addAll(super.entrySet());
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public WrappingVariablesMap clone() {
        return (WrappingVariablesMap)super.clone();
    }

    private boolean containsRemovedKey(Object key) {
        return this.targetRemovedKeys != null && this.targetRemovedKeys.contains(key);
    }
}

