/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.doctype.resolution;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.thymeleaf.doctype.DocTypeIdentifier;
import org.thymeleaf.doctype.resolution.IDocTypeResolutionEntry;
import org.thymeleaf.util.Validate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class FileDocTypeResolutionEntry
implements IDocTypeResolutionEntry {
    private final DocTypeIdentifier systemID;
    private final DocTypeIdentifier publicID;
    private final File file;

    public FileDocTypeResolutionEntry(DocTypeIdentifier publicID, DocTypeIdentifier systemID, File file) {
        Validate.notNull(file, "File cannot be null");
        this.publicID = publicID;
        this.systemID = systemID;
        this.file = file;
    }

    public DocTypeIdentifier getSystemID() {
        return this.systemID;
    }

    public DocTypeIdentifier getPublicID() {
        return this.publicID;
    }

    public InputSource createInputSource() throws SAXException, IOException {
        return new InputSource(new FileInputStream(this.file));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.publicID == null ? 0 : this.publicID.hashCode());
        result = 31 * result + (this.systemID == null ? 0 : this.systemID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileDocTypeResolutionEntry other = (FileDocTypeResolutionEntry)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        if (this.publicID == null ? other.publicID != null : !this.publicID.equals(other.publicID)) {
            return false;
        }
        return !(this.systemID == null ? other.systemID != null : !this.systemID.equals(other.systemID));
    }
}

