/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.dom;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class Attribute
implements Serializable {
    private static final long serialVersionUID = 7133984802585560958L;
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, String[]>> prefixedAttributeNamesByPrefix = new ConcurrentHashMap(3);
    private static final ConcurrentHashMap<String, String> prefixesByAttributeName = new ConcurrentHashMap(100);
    private final String originalName;
    private final String normalizedName;
    private final boolean onlyName;
    private final boolean valueIsEscaped;
    private final String value;

    public Attribute(String name, boolean onlyName, String value) {
        this(name, onlyName, value, false);
    }

    public Attribute(String name, boolean onlyName, String value, boolean valueIsEscaped) {
        Validate.notNull(name, "Attribute name cannot be null");
        this.originalName = name;
        this.normalizedName = Attribute.normalizeAttributeName(name);
        this.onlyName = onlyName;
        this.valueIsEscaped = valueIsEscaped;
        this.value = value;
    }

    private Attribute(String originalName, String normalizedName, boolean onlyName, String value, boolean valueIsEscaped) {
        this.originalName = originalName;
        this.normalizedName = normalizedName;
        this.onlyName = onlyName;
        this.valueIsEscaped = valueIsEscaped;
        this.value = value;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getNormalizedName() {
        return this.normalizedName;
    }

    @Deprecated
    public String getNormalizedPrefix() {
        return Attribute.getPrefixFromAttributeName(this.normalizedName);
    }

    @Deprecated
    public String getUnprefixedNormalizedName() {
        return Attribute.getUnprefixedAttributeName(this.normalizedName);
    }

    @Deprecated
    public boolean hasPrefix() {
        int colonPos = this.normalizedName.indexOf(58);
        return colonPos != -1;
    }

    public boolean isOnlyName() {
        return this.onlyName;
    }

    public String getValue() {
        if (this.valueIsEscaped) {
            return HtmlEscape.unescapeHtml((String)this.value);
        }
        return this.value;
    }

    public String getEscapedValue() {
        if (this.valueIsEscaped) {
            return this.value;
        }
        return HtmlEscape.escapeHtml4Xml((String)this.value);
    }

    public String getOriginalValue() {
        return this.value;
    }

    @Deprecated
    public boolean isXmlnsAttribute() {
        return this.normalizedName.startsWith("xmlns:");
    }

    @Deprecated
    public String getXmlnsPrefix() {
        if (!this.isXmlnsAttribute()) {
            return null;
        }
        return this.normalizedName.substring("xmlns:".length());
    }

    Attribute cloneForValue(boolean onlyName, String value, boolean valueIsEscaped) {
        return new Attribute(this.originalName, this.normalizedName, onlyName, value, valueIsEscaped);
    }

    public static String normalizeAttributeName(String name) {
        if (name == null) {
            return null;
        }
        return name.toLowerCase();
    }

    public static String[] applyPrefixToAttributeName(String name, String dialectPrefix) {
        String[] prefixedAttributeNames;
        if (name == null) {
            return null;
        }
        String prefix = dialectPrefix == null ? "" : dialectPrefix;
        ConcurrentHashMap<String, Object> prefixedAttributeNamesForPrefix = prefixedAttributeNamesByPrefix.get(prefix);
        if (prefixedAttributeNamesForPrefix == null) {
            prefixedAttributeNamesForPrefix = new ConcurrentHashMap(100);
            prefixedAttributeNamesByPrefix.put(prefix, prefixedAttributeNamesForPrefix);
        }
        if ((prefixedAttributeNames = prefixedAttributeNamesForPrefix.get(name)) != null) {
            return prefixedAttributeNames;
        }
        prefixedAttributeNames = StringUtils.isEmptyOrWhitespace(prefix) ? new String[]{name} : new String[]{prefix + ':' + name, "data-" + prefix + '-' + name};
        prefixedAttributeNamesForPrefix.put(name, prefixedAttributeNames);
        return prefixedAttributeNames;
    }

    public static String getUnprefixedAttributeName(String attributeName) {
        int dashPos;
        if (attributeName == null) {
            return null;
        }
        int colonPos = attributeName.indexOf(58);
        if (colonPos != -1) {
            return attributeName.substring(colonPos + 1);
        }
        if (attributeName.startsWith("data-") && (dashPos = attributeName.substring(5).indexOf(45)) != -1) {
            return attributeName.substring(dashPos + 6);
        }
        return attributeName;
    }

    public static String getPrefixFromAttributeName(String attributeName) {
        int dashPos;
        if (attributeName == null) {
            return null;
        }
        String prefix = prefixesByAttributeName.get(attributeName);
        if (prefix != null) {
            if (prefix.length() == 0) {
                return null;
            }
            return prefix;
        }
        int colonPos = attributeName.indexOf(58);
        if (colonPos != -1) {
            prefix = attributeName.substring(0, colonPos);
        } else if (attributeName.startsWith("data-") && (dashPos = attributeName.substring(5).indexOf(45)) != -1) {
            prefix = attributeName.substring(5, dashPos + 5);
        }
        if (prefix == null) {
            prefix = "";
        }
        prefixesByAttributeName.put(attributeName, prefix);
        if (prefix.length() == 0) {
            return null;
        }
        return prefix;
    }
}

