/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.messageresolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.exceptions.AlreadyInitializedException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.messageresolver.IMessageResolver;

public abstract class AbstractMessageResolver
implements IMessageResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMessageResolver.class);
    private String name = null;
    private Integer order = null;
    private volatile boolean initialized = false;

    protected AbstractMessageResolver() {
    }

    protected final boolean isInitialized() {
        return this.initialized;
    }

    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            if (this.name == null) {
                this.name = this.getClass().getName();
            }
            logger.info("[THYMELEAF] INITIALIZING MESSAGE RESOLVER: " + this.name);
            this.initializeSpecific();
            this.initialized = true;
            logger.info("[THYMELEAF] MESSAGE RESOLVER INITIALIZED OK");
        }
    }

    protected void initializeSpecific() {
    }

    protected final void checkNotInitialized() {
        if (this.isInitialized()) {
            throw new AlreadyInitializedException("Cannot modify message resolver when it has already been initialized");
        }
    }

    protected final void checkInitialized() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Message Resolver has not been initialized");
        }
    }

    public final String getName() {
        this.checkInitialized();
        return this.name;
    }

    protected final String unsafeGetName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkNotInitialized();
        this.name = name;
    }

    public final Integer getOrder() {
        this.checkInitialized();
        return this.order;
    }

    protected final Integer unsafeGetOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.checkNotInitialized();
        this.order = order;
    }
}

