/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.Arguments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorResult {
    private static final Map<String, Object> EMPTY_VARIABLES = Collections.unmodifiableMap(new HashMap(1, 1.0f));
    public static final ProcessorResult OK = new ProcessorResult(null, false, false, false, false, null, false);
    private final Map<String, Object> localVariables;
    private final boolean processTextNodes;
    private final boolean processTextNodesSet;
    private final boolean processCommentNodes;
    private final boolean processCommentNodesSet;
    private final Object selectionTarget;
    private final boolean selectionTargetSet;

    public static ProcessorResult ok() {
        return OK;
    }

    public static ProcessorResult setLocalVariables(Map<String, Object> localVariables) {
        return new ProcessorResult(localVariables, false, false, false, false, null, false);
    }

    public static ProcessorResult setProcessTextAndCommentNodes(boolean processTextNodes, boolean processCommentNodes) {
        return new ProcessorResult(null, processTextNodes, true, processCommentNodes, true, null, false);
    }

    public static ProcessorResult setLocalVariablesAndProcessTextAndCommentNodes(Map<String, Object> localVariables, boolean processTextNodes, boolean processCommentNodes) {
        return new ProcessorResult(localVariables, processTextNodes, true, processCommentNodes, true, null, false);
    }

    public static ProcessorResult setProcessTextNodes(boolean processTextNodes) {
        return new ProcessorResult(null, processTextNodes, true, false, false, null, false);
    }

    public static ProcessorResult setLocalVariablesAndProcessTextNodes(Map<String, Object> localVariables, boolean processTextNodes) {
        return new ProcessorResult(localVariables, processTextNodes, true, false, false, null, false);
    }

    public static ProcessorResult setProcessCommentNodes(boolean processCommentNodes) {
        return new ProcessorResult(null, false, false, processCommentNodes, true, null, false);
    }

    public static ProcessorResult setLocalVariablesAndProcessCommentNodes(Map<String, Object> localVariables, boolean processCommentNodes) {
        return new ProcessorResult(localVariables, false, false, processCommentNodes, true, null, false);
    }

    public static ProcessorResult setSelectionTarget(Object selectionTarget) {
        return new ProcessorResult(null, false, false, false, false, selectionTarget, true);
    }

    public static ProcessorResult setLocalVariablesAndSelectionTarget(Map<String, Object> localVariables, Object selectionTarget) {
        return new ProcessorResult(localVariables, false, false, false, false, selectionTarget, true);
    }

    private ProcessorResult(Map<String, Object> localVariables, boolean processTextNodes, boolean processTextNodesSet, boolean processCommentNodes, boolean processCommentNodesSet, Object selectionTarget, boolean selectionTargetSet) {
        this.localVariables = localVariables == null ? EMPTY_VARIABLES : Collections.unmodifiableMap(new HashMap<String, Object>(localVariables));
        this.processTextNodes = processTextNodes;
        this.processTextNodesSet = processTextNodesSet;
        this.processCommentNodes = processCommentNodes;
        this.processCommentNodesSet = processCommentNodesSet;
        this.selectionTarget = selectionTarget;
        this.selectionTargetSet = selectionTargetSet;
    }

    public boolean hasLocalVariables() {
        return this.localVariables != null && this.localVariables.size() > 0;
    }

    public Map<String, Object> getLocalVariables() {
        return this.localVariables;
    }

    public boolean getProcessTextNodes() {
        return this.processTextNodes;
    }

    public boolean isProcessTextNodesSet() {
        return this.processTextNodesSet;
    }

    public boolean getProcessCommentNodes() {
        return this.processCommentNodes;
    }

    public boolean isProcessCommentNodesSet() {
        return this.processCommentNodesSet;
    }

    public Object getSelectionTarget() {
        return this.selectionTarget;
    }

    public boolean isSelectionTargetSet() {
        return this.selectionTargetSet;
    }

    public boolean isOK() {
        return (this.localVariables == null || this.localVariables.size() == 0) && !this.processTextNodesSet && !this.processCommentNodesSet && !this.selectionTargetSet;
    }

    public Arguments computeNewArguments(Arguments arguments) {
        if (this.isOK()) {
            return arguments;
        }
        if (this.localVariables != null && this.localVariables.size() > 0) {
            if (this.selectionTargetSet) {
                return arguments.addLocalVariablesAndSelectionTarget(this.localVariables, this.selectionTarget);
            }
            return arguments.addLocalVariables(this.localVariables);
        }
        if (this.selectionTargetSet) {
            return arguments.setSelectionTarget(this.selectionTarget);
        }
        return arguments;
    }
}

