/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.io.Serializable;
import java.util.List;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FragmentSignature
implements Serializable {
    private static final long serialVersionUID = 6847640942405961705L;
    private static final char FRAGMENT_SIGNATURE_PARAMETERS_START = '(';
    private static final char FRAGMENT_SIGNATURE_PARAMETERS_END = ')';
    private final String fragmentName;
    private final List<String> parameterNames;

    public FragmentSignature(String fragmentName, List<String> parameterNames) {
        Validate.notEmpty(fragmentName, "Fragment name cannot be null or empty");
        this.fragmentName = fragmentName;
        this.parameterNames = parameterNames;
    }

    public String getFragmentName() {
        return this.fragmentName;
    }

    public boolean hasParameters() {
        return this.parameterNames != null && this.parameterNames.size() > 0;
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    public String getStringRepresentation() {
        if (this.parameterNames == null || this.parameterNames.size() == 0) {
            return this.fragmentName;
        }
        return this.fragmentName + " " + '(' + StringUtils.join(this.parameterNames, ',') + ')';
    }

    public String toString() {
        return this.getStringRepresentation();
    }
}

