/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.thymeleaf.Configuration;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.ExpressionCache;
import org.thymeleaf.standard.expression.FragmentSelectionUtils;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FragmentSignatureUtils {
    private static final char FRAGMENT_SIGNATURE_PARAMETERS_START = '(';
    private static final char FRAGMENT_SIGNATURE_PARAMETERS_END = ')';

    public static FragmentSignature parseFragmentSignature(Configuration configuration, String input) {
        FragmentSignature cachedFragmentSignature;
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(input, "Input cannot be null");
        if (configuration != null && (cachedFragmentSignature = ExpressionCache.getFragmentSignatureFromCache(configuration, input)) != null) {
            return cachedFragmentSignature;
        }
        FragmentSignature fragmentSignature = FragmentSignatureUtils.internalParseFragmentSignature(input.trim());
        if (fragmentSignature == null) {
            throw new TemplateProcessingException("Could not parse as fragment signature: \"" + input + "\"");
        }
        if (configuration != null) {
            ExpressionCache.putFragmentSignatureIntoCache(configuration, input, fragmentSignature);
        }
        return fragmentSignature;
    }

    static FragmentSignature internalParseFragmentSignature(String input) {
        ArrayList<String> parameterNames;
        String parameters;
        if (StringUtils.isEmptyOrWhitespace(input)) {
            return null;
        }
        int parameterStart = input.lastIndexOf(40);
        int parameterEnd = input.lastIndexOf(41);
        if (parameterStart != -1 && parameterStart >= parameterEnd) {
            return null;
        }
        String fragmentName = parameterStart == -1 ? input.trim() : input.substring(0, parameterStart).trim();
        String string = parameters = parameterStart == -1 ? null : input.substring(parameterStart + 1, input.length() - 1);
        if (parameters != null) {
            String[] parameterArray = StringUtils.split(parameters, ",");
            if (parameterArray.length == 0) {
                parameterNames = null;
            } else {
                parameterNames = new ArrayList<String>(parameterArray.length + 2);
                for (String parameter : parameterArray) {
                    parameterNames.add(parameter.trim());
                }
            }
        } else {
            parameterNames = null;
        }
        return new FragmentSignature(fragmentName, parameterNames);
    }

    public static Map<String, Object> processParameters(FragmentSignature fragmentSignature, Map<String, Object> specifiedParameters) {
        Validate.notNull(fragmentSignature, "Fragment signature cannot be null");
        if (specifiedParameters == null || specifiedParameters.size() == 0) {
            if (fragmentSignature.hasParameters()) {
                throw new TemplateProcessingException("Cannot resolve fragment. Signature \"" + fragmentSignature.getStringRepresentation() + "\" " + "declares parameters, but fragment selection did not specify any parameters.");
            }
            return null;
        }
        boolean parametersAreSynthetic = FragmentSelectionUtils.parameterNamesAreSynthetic(specifiedParameters.keySet());
        if (parametersAreSynthetic && !fragmentSignature.hasParameters()) {
            throw new TemplateProcessingException("Cannot resolve fragment. Signature \"" + fragmentSignature.getStringRepresentation() + "\" " + "declares no parameters, but fragment selection did specify parameters in a synthetic manner " + "(without names), which is not correct due to the fact parameters cannot be assigned names " + "unless signature specifies these names.");
        }
        if (parametersAreSynthetic) {
            List<String> signatureParameterNames = fragmentSignature.getParameterNames();
            if (signatureParameterNames.size() != specifiedParameters.size()) {
                throw new TemplateProcessingException("Cannot resolve fragment. Signature \"" + fragmentSignature.getStringRepresentation() + "\" " + "declares " + signatureParameterNames.size() + " parameters, but fragment selection specifies " + specifiedParameters.size() + " parameters. Fragment selection does not correctly match.");
            }
            HashMap<String, Object> processedParameters = new HashMap<String, Object>(signatureParameterNames.size() + 1, 1.0f);
            int index = 0;
            for (String parameterName : signatureParameterNames) {
                String syntheticParameterName = FragmentSelectionUtils.getSyntheticParameterNameForIndex(index++);
                Object parameterValue = specifiedParameters.get(syntheticParameterName);
                processedParameters.put(parameterName, parameterValue);
            }
            return processedParameters;
        }
        if (!fragmentSignature.hasParameters()) {
            return specifiedParameters;
        }
        List<String> parameterNames = fragmentSignature.getParameterNames();
        for (String parameterName : parameterNames) {
            if (specifiedParameters.containsKey(parameterName)) continue;
            throw new TemplateProcessingException("Cannot resolve fragment. Signature \"" + fragmentSignature.getStringRepresentation() + "\" " + "declares parameter \"" + parameterName + "\", which is not specified at the fragment " + "selection.");
        }
        return specifiedParameters;
    }

    private FragmentSignatureUtils() {
    }
}

