/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.expression.Assignation;
import org.thymeleaf.standard.expression.AssignationSequence;
import org.thymeleaf.standard.expression.AssignationUtils;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.SimpleExpression;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.TextLiteralExpression;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;
import org.unbescape.uri.UriEscape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkExpression
extends SimpleExpression {
    private static final Logger logger = LoggerFactory.getLogger(LinkExpression.class);
    private static final long serialVersionUID = -564516592085017252L;
    static final char SELECTOR = '@';
    private static final char PARAMS_START_CHAR = '(';
    private static final char PARAMS_END_CHAR = ')';
    private static final char URL_TEMPLATE_DELIMITER_PREFIX = '{';
    private static final char URL_TEMPLATE_DELIMITER_SUFFIX = '}';
    private static final Pattern LINK_PATTERN = Pattern.compile("^\\s*\\@\\{(.+?)\\}\\s*$", 32);
    private static final String URL_PARAM_NO_VALUE = "%%%__NO_VALUE__%%%";
    private final IStandardExpression base;
    private final AssignationSequence parameters;

    public LinkExpression(IStandardExpression base, AssignationSequence parameters) {
        Validate.notNull(base, "Base cannot be null");
        this.base = base;
        this.parameters = parameters;
    }

    public IStandardExpression getBase() {
        return this.base;
    }

    public AssignationSequence getParameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append('{');
        sb.append(this.base);
        if (this.hasParameters()) {
            sb.append('(');
            sb.append(this.parameters.getStringRepresentation());
            sb.append(')');
        }
        sb.append('}');
        return sb.toString();
    }

    static LinkExpression parseLink(String input) {
        Matcher matcher = LINK_PATTERN.matcher(input);
        if (!matcher.matches()) {
            return null;
        }
        String content = matcher.group(1);
        if (StringUtils.isEmptyOrWhitespace(content)) {
            return null;
        }
        String trimmedInput = content.trim();
        if (trimmedInput.endsWith(String.valueOf(')'))) {
            boolean inLiteral = false;
            int nestParLevel = 0;
            for (int i = trimmedInput.length() - 1; i >= 0; --i) {
                char c = trimmedInput.charAt(i);
                if (c == '\'') {
                    if (i != 0 && content.charAt(i - 1) == '\\') continue;
                    inLiteral = !inLiteral;
                    continue;
                }
                if (!inLiteral && c == ')') {
                    ++nestParLevel;
                    continue;
                }
                if (inLiteral || c != '(') continue;
                if (--nestParLevel < 0) {
                    return null;
                }
                if (nestParLevel != 0) continue;
                if (i == 0) {
                    Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(trimmedInput);
                    if (baseExpr == null) {
                        return null;
                    }
                    return new LinkExpression(baseExpr, null);
                }
                String base = trimmedInput.substring(0, i).trim();
                String parameters = trimmedInput.substring(i + 1, trimmedInput.length() - 1).trim();
                Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(base);
                if (baseExpr == null) {
                    return null;
                }
                AssignationSequence parametersAssigSeq = AssignationUtils.internalParseAssignationSequence(parameters, true);
                if (parametersAssigSeq == null) {
                    return null;
                }
                return new LinkExpression(baseExpr, parametersAssigSeq);
            }
            return null;
        }
        Expression baseExpr = LinkExpression.parseBaseDefaultAsLiteral(trimmedInput);
        if (baseExpr == null) {
            return null;
        }
        return new LinkExpression(baseExpr, null);
    }

    private static Expression parseBaseDefaultAsLiteral(String base) {
        if (StringUtils.isEmptyOrWhitespace(base)) {
            return null;
        }
        Expression expr = Expression.parse(base);
        if (expr == null) {
            return Expression.parse(TextLiteralExpression.wrapStringIntoLiteral(base));
        }
        return expr;
    }

    static Object executeLink(Configuration configuration, IProcessingContext processingContext, LinkExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating link: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        IStandardExpression baseExpression = expression.getBase();
        Object base = baseExpression.execute(configuration, processingContext, expContext);
        if ((base = LiteralValue.unwrap(base)) != null && !(base instanceof String)) {
            base = base.toString();
        }
        if (base == null || StringUtils.isEmptyOrWhitespace((String)base)) {
            base = "";
        }
        String linkBase = (String)base;
        if (!(LinkExpression.isWebContext(processingContext.getContext()) || LinkExpression.isLinkBaseAbsolute(linkBase) || LinkExpression.isLinkBaseServerRelative(linkBase))) {
            throw new TemplateProcessingException("Link base \"" + linkBase + "\" cannot be context relative (/) or page relative unless you implement the " + IWebContext.class.getName() + " interface (context is of class: " + processingContext.getContext().getClass().getName() + ")");
        }
        Map<String, List<Object>> parameters = expression.hasParameters() ? LinkExpression.resolveParameters(configuration, processingContext, expression, expContext) : Collections.EMPTY_MAP;
        int hashPosition = linkBase.indexOf(35);
        String urlFragment = "";
        if (hashPosition > 0) {
            urlFragment = linkBase.substring(hashPosition);
            linkBase = linkBase.substring(0, hashPosition);
        }
        linkBase = LinkExpression.replaceTemplateParamsInBase(linkBase, parameters);
        int questionMarkPosition = linkBase.indexOf(63);
        StringBuilder parametersBuilder = new StringBuilder();
        for (Map.Entry<String, List<Object>> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            List<Object> parameterValues = parameterEntry.getValue();
            for (Object parameterObjectValue : parameterValues) {
                if (parametersBuilder.length() == 0) {
                    if (questionMarkPosition == -1) {
                        parametersBuilder.append("?");
                    } else {
                        parametersBuilder.append("&");
                    }
                } else {
                    parametersBuilder.append("&");
                }
                parametersBuilder.append(UriEscape.escapeUriQueryParam((String)parameterName));
                String parameterValue = parameterObjectValue == null ? "" : parameterObjectValue.toString();
                if (URL_PARAM_NO_VALUE.equals(parameterValue)) continue;
                parametersBuilder.append("=").append(UriEscape.escapeUriQueryParam((String)parameterValue));
            }
        }
        if (!LinkExpression.isWebContext(processingContext.getContext())) {
            if (LinkExpression.isLinkBaseAbsolute(linkBase)) {
                return linkBase + parametersBuilder + urlFragment;
            }
            return linkBase.substring(1) + parametersBuilder + urlFragment;
        }
        IWebContext webContext = (IWebContext)processingContext.getContext();
        HttpServletRequest request = webContext.getHttpServletRequest();
        HttpServletResponse response = webContext.getHttpServletResponse();
        String url = null;
        url = LinkExpression.isLinkBaseContextRelative(linkBase) ? request.getContextPath() + linkBase + parametersBuilder + urlFragment : (LinkExpression.isLinkBaseServerRelative(linkBase) ? linkBase.substring(1) + parametersBuilder + urlFragment : (LinkExpression.isLinkBaseAbsolute(linkBase) ? linkBase + parametersBuilder + urlFragment : linkBase + parametersBuilder + urlFragment));
        return response != null ? response.encodeURL(url) : url;
    }

    private static boolean isWebContext(IContext context) {
        return context instanceof IWebContext;
    }

    private static boolean isLinkBaseAbsolute(String linkBase) {
        return linkBase.contains("://") || linkBase.toLowerCase().startsWith("mailto:") || linkBase.startsWith("//");
    }

    private static boolean isLinkBaseContextRelative(String linkBase) {
        return linkBase.startsWith("/") && !linkBase.startsWith("//");
    }

    private static boolean isLinkBaseServerRelative(String linkBase) {
        return linkBase.startsWith("~/");
    }

    private static Map<String, List<Object>> resolveParameters(Configuration configuration, IProcessingContext processingContext, LinkExpression expression, StandardExpressionExecutionContext expContext) {
        AssignationSequence assignationValues = expression.getParameters();
        LinkedHashMap<String, List<Object>> parameters = new LinkedHashMap<String, List<Object>>(assignationValues.size() + 1, 1.0f);
        for (Assignation assignationValue : assignationValues) {
            String parameterName;
            IStandardExpression parameterNameExpr = assignationValue.getLeft();
            IStandardExpression parameterValueExpr = assignationValue.getRight();
            Object parameterNameValue = parameterNameExpr.execute(configuration, processingContext, expContext);
            String string = parameterName = parameterNameValue == null ? null : parameterNameValue.toString();
            if (StringUtils.isEmptyOrWhitespace(parameterName)) {
                throw new TemplateProcessingException("Parameters in link expression \"" + expression.getStringRepresentation() + "\" are " + "incorrect: parameter name expression \"" + parameterNameExpr.getStringRepresentation() + "\" evaluated as null or empty string.");
            }
            ArrayList<String> currentParameterValues = (ArrayList<String>)parameters.get(parameterName);
            if (currentParameterValues == null) {
                currentParameterValues = new ArrayList<String>(4);
                parameters.put(parameterName, currentParameterValues);
            }
            if (parameterValueExpr == null) {
                currentParameterValues.add(URL_PARAM_NO_VALUE);
                continue;
            }
            Object value = parameterValueExpr.execute(configuration, processingContext, expContext);
            if (value == null) {
                currentParameterValues.add("");
                continue;
            }
            currentParameterValues.addAll(LinkExpression.convertParameterValueToList(LiteralValue.unwrap(value)));
        }
        return parameters;
    }

    private static List<Object> convertParameterValueToList(Object parameterValue) {
        if (parameterValue instanceof Iterable) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            for (Object obj : (Iterable)parameterValue) {
                result.add(obj);
            }
            return result;
        }
        if (parameterValue.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>(4);
            if (parameterValue instanceof byte[]) {
                for (byte obj : (byte[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof short[]) {
                for (short obj : (short[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof int[]) {
                for (int obj : (int[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof long[]) {
                for (long obj : (long[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof float[]) {
                for (float obj : (float[])parameterValue) {
                    result.add(Float.valueOf(obj));
                }
            } else if (parameterValue instanceof double[]) {
                for (double obj : (double[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof boolean[]) {
                for (boolean obj : (boolean[])parameterValue) {
                    result.add(obj);
                }
            } else if (parameterValue instanceof char[]) {
                for (char obj : (char[])parameterValue) {
                    result.add(Character.valueOf(obj));
                }
            } else {
                Object[] objParameterValue = (Object[])parameterValue;
                Collections.addAll(result, objParameterValue);
            }
            return result;
        }
        return Collections.singletonList(parameterValue);
    }

    static String replaceTemplateParamsInBase(String linkBase, Map<String, List<Object>> parameters) {
        String baseQuery;
        String basePath;
        int linkBaseLen = linkBase.length();
        boolean templateFound = false;
        for (int i = 0; i < linkBaseLen; ++i) {
            char c = linkBase.charAt(i);
            if (c != '{') continue;
            templateFound = true;
            break;
        }
        if (!templateFound) {
            return linkBase;
        }
        int questionMarkPosition = linkBase.indexOf(63);
        if (questionMarkPosition == -1) {
            basePath = linkBase;
            baseQuery = null;
        } else {
            basePath = linkBase.substring(0, questionMarkPosition);
            baseQuery = linkBase.substring(questionMarkPosition);
        }
        HashSet<String> usedParams = new HashSet<String>(5);
        for (Map.Entry<String, List<Object>> param : parameters.entrySet()) {
            String parameterValue;
            StringBuilder strBuilder;
            String paramName = param.getKey();
            List<Object> paramValues = param.getValue();
            String template = '{' + paramName + '}';
            if (basePath.contains(template)) {
                usedParams.add(paramName);
                strBuilder = new StringBuilder();
                for (Object parameterObjectValue : paramValues) {
                    parameterValue = parameterObjectValue == null ? "" : parameterObjectValue.toString();
                    if (URL_PARAM_NO_VALUE.equals(parameterValue)) continue;
                    if (strBuilder.length() > 0) {
                        strBuilder.append(',');
                    }
                    strBuilder.append(parameterValue);
                }
                basePath = basePath.replace(template, UriEscape.escapeUriPath((String)strBuilder.toString()));
                continue;
            }
            if (baseQuery == null || !baseQuery.contains(template)) continue;
            usedParams.add(paramName);
            strBuilder = new StringBuilder();
            for (Object parameterObjectValue : paramValues) {
                parameterValue = parameterObjectValue == null ? "" : parameterObjectValue.toString();
                if (URL_PARAM_NO_VALUE.equals(parameterValue)) continue;
                if (strBuilder.length() > 0) {
                    strBuilder.append(',');
                }
                strBuilder.append(parameterValue);
            }
            baseQuery = baseQuery.replace(template, UriEscape.escapeUriQueryParam((String)strBuilder.toString()));
        }
        for (String usedParam : usedParams) {
            parameters.remove(usedParam);
        }
        return basePath + (baseQuery != null ? baseQuery : "");
    }
}

