/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.Token;

public final class NullTokenExpression
extends Token {
    private static final Logger logger = LoggerFactory.getLogger(NullTokenExpression.class);
    private static final long serialVersionUID = -927282151625647619L;
    private static final NullTokenExpression SINGLETON = new NullTokenExpression();

    public NullTokenExpression() {
        super(null);
    }

    public String getStringRepresentation() {
        return "null";
    }

    static NullTokenExpression parseNullToken(String input) {
        if ("null".equalsIgnoreCase(input)) {
            return SINGLETON;
        }
        return null;
    }

    static Object executeNullToken(IProcessingContext processingContext, NullTokenExpression expression, StandardExpressionExecutionContext expContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating null token: \"{}\"", (Object)TemplateEngine.threadIndex(), (Object)expression.getStringRepresentation());
        }
        return expression.getValue();
    }
}

