/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import org.thymeleaf.standard.expression.SimpleExpression;

public abstract class Token
extends SimpleExpression {
    private static final long serialVersionUID = 4357087922344497120L;
    private final Object value;

    protected Token(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStringRepresentation() {
        return this.value.toString();
    }

    public String toString() {
        return this.getStringRepresentation();
    }

    public static boolean isTokenChar(String context, int pos) {
        char c = context.charAt(pos);
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c == ' ' || c == '\n' || c == '(' || c == ')' || c == '\'' || c == '\"' || c == '<' || c == '>' || c == '{' || c == '}' || c == '=' || c == ',' || c == ';' || c == ':' || c == '+' || c == '*' || c == '$' || c == '%' || c == '&' || c == '#') {
            return false;
        }
        if (c == '[' || c == ']' || c == '.' || c == '_') {
            return true;
        }
        if (c == '-') {
            int contextLen;
            if (pos > 0) {
                for (int i = pos - 1; i >= 0 && Token.isTokenChar(context, i); --i) {
                    char cc = context.charAt(i);
                    if (cc >= '0' && cc <= '9' || cc == '.') continue;
                    return true;
                }
            }
            if (pos + 1 < (contextLen = context.length())) {
                for (int i = pos + 1; i < contextLen; ++i) {
                    char cc = context.charAt(i);
                    if (cc == '-') {
                        return true;
                    }
                    if (!Token.isTokenChar(context, i)) break;
                    if (cc >= '0' && cc <= '9' || cc == '.') continue;
                    return true;
                }
            }
            return false;
        }
        if (c == '\u00b7') {
            return true;
        }
        if (c >= '\u00c0' && c <= '\u00d6') {
            return true;
        }
        if (c >= '\u00d8' && c <= '\u00f6') {
            return true;
        }
        if (c >= '\u00f8' && c <= '\u02ff') {
            return true;
        }
        if (c >= '\u0300' && c <= '\u036f') {
            return true;
        }
        if (c >= '\u0370' && c <= '\u037d') {
            return true;
        }
        if (c >= '\u037f' && c <= '\u1fff') {
            return true;
        }
        if (c >= '\u200c' && c <= '\u200d') {
            return true;
        }
        if (c >= '\u203f' && c <= '\u2040') {
            return true;
        }
        if (c >= '\u2070' && c <= '\u218f') {
            return true;
        }
        if (c >= '\u2c00' && c <= '\u2fef') {
            return true;
        }
        if (c >= '\u3001' && c <= '\ud7ff') {
            return true;
        }
        if (c >= '\uf900' && c <= '\ufdcf') {
            return true;
        }
        if (c >= '\ufdf0' && c <= '\ufffd') {
            return true;
        }
        return c >= '\ufdf0' && c <= '\ufffd';
    }

    public static final class TokenParsingTracer {
        public static final char TOKEN_SUBSTITUTE = '#';

        private TokenParsingTracer() {
        }

        public static String trace(String input) {
            StringBuilder strBuilder = new StringBuilder();
            int inputLen = input.length();
            for (int i = 0; i < inputLen; ++i) {
                if (Token.isTokenChar(input, i)) {
                    strBuilder.append('#');
                    continue;
                }
                strBuilder.append(input.charAt(i));
            }
            return strBuilder.toString();
        }
    }
}

