/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.fragment;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StandardFragment {
    private final String templateName;
    private final IFragmentSpec fragmentSpec;
    private final Map<String, Object> parameters;
    private final String dialectPrefix;
    private final String fragmentSignatureAttributeName;

    public StandardFragment(String templateName, IFragmentSpec fragmentSpec, Map<String, Object> parameters) {
        this(templateName, fragmentSpec, parameters, null, null);
    }

    public StandardFragment(String templateName, IFragmentSpec fragmentSpec, Map<String, Object> parameters, String dialectPrefix, String fragmentSignatureAttributeName) {
        Validate.notNull(fragmentSpec, "Fragment spec cannot be null or empty");
        this.templateName = templateName;
        this.fragmentSpec = fragmentSpec;
        this.parameters = parameters;
        this.dialectPrefix = dialectPrefix;
        this.fragmentSignatureAttributeName = fragmentSignatureAttributeName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public IFragmentSpec getFragmentSpec() {
        return this.fragmentSpec;
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<Node> extractFragment(Configuration configuration, IProcessingContext context, TemplateRepository templateRepository) {
        FragmentSignature fragmentSignature;
        String attributeValue;
        NestableAttributeHolderNode attributeHolderNode;
        Node node;
        TemplateProcessingParameters fragmentTemplateProcessingParameters;
        Template parsedFragmentTemplate;
        List<Node> nodes;
        String targetTemplateName = this.getTemplateName();
        if (targetTemplateName == null) {
            if (context != null && context instanceof Arguments) {
                targetTemplateName = ((Arguments)context).getTemplateName();
            } else {
                throw new TemplateProcessingException("In order to extract fragment from current template (templateName == null), processing context must be a non-null instance of the Arguments class (but is: " + (context == null ? null : context.getClass().getName()) + ")");
            }
        }
        if ((nodes = this.fragmentSpec.extractFragment(configuration, (parsedFragmentTemplate = templateRepository.getTemplate(fragmentTemplateProcessingParameters = new TemplateProcessingParameters(configuration, targetTemplateName, context))).getDocument().getChildren())) == null) {
            return null;
        }
        for (Node node2 : nodes) {
            if (!node2.hasParent()) continue;
            node2.getParent().clearChildren();
        }
        if (nodes.size() == 1 && this.fragmentSignatureAttributeName != null && (node = nodes.get(0)) instanceof NestableAttributeHolderNode && (attributeHolderNode = (NestableAttributeHolderNode)node).hasNormalizedAttribute(this.dialectPrefix, this.fragmentSignatureAttributeName) && (attributeValue = attributeHolderNode.getAttributeValueFromNormalizedName(this.dialectPrefix, this.fragmentSignatureAttributeName)) != null && (fragmentSignature = FragmentSignatureUtils.parseFragmentSignature(configuration, attributeValue)) != null) {
            Map<String, Object> processedParameters = FragmentSignatureUtils.processParameters(fragmentSignature, this.parameters);
            StandardFragment.applyParameters(nodes, processedParameters);
            return nodes;
        }
        StandardFragment.applyParameters(nodes, this.parameters);
        return nodes;
    }

    private static void applyParameters(List<Node> nodes, Map<String, Object> parameters) {
        for (Node node : nodes) {
            node.setAllNodeLocalVariables(parameters);
        }
    }
}

