/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.fragment;

import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Attribute;
import org.thymeleaf.dom.DOMSelector;
import org.thymeleaf.dom.NestableAttributeHolderNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.standard.expression.FragmentSignature;
import org.thymeleaf.standard.expression.FragmentSignatureUtils;
import org.thymeleaf.util.Validate;

public final class StandardFragmentSignatureNodeReferenceChecker
extends DOMSelector.AbstractNodeReferenceChecker {
    private final Configuration configuration;
    private final String dialectPrefix;
    private final String fragmentAttributeName;

    public StandardFragmentSignatureNodeReferenceChecker(Configuration configuration, String dialectPrefix, String fragmentAttributeName) {
        Validate.notNull(configuration, "Configuration cannot be null");
        Validate.notNull(fragmentAttributeName, "Fragment attribute name cannot be null");
        this.configuration = configuration;
        this.dialectPrefix = dialectPrefix;
        this.fragmentAttributeName = Attribute.normalizeAttributeName(fragmentAttributeName);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getDialectPrefix() {
        return this.dialectPrefix;
    }

    public String getFragmentAttributeName() {
        return this.fragmentAttributeName;
    }

    public boolean checkReference(Node node, String referenceValue) {
        String signatureFragmentName;
        FragmentSignature fragmentSignature;
        String elementAttrValue;
        NestableAttributeHolderNode attributeHolderNode;
        if (referenceValue == null) {
            return true;
        }
        return node instanceof NestableAttributeHolderNode && (attributeHolderNode = (NestableAttributeHolderNode)node).hasNormalizedAttribute(this.dialectPrefix, this.fragmentAttributeName) && (elementAttrValue = attributeHolderNode.getAttributeValueFromNormalizedName(this.dialectPrefix, this.fragmentAttributeName)) != null && (fragmentSignature = FragmentSignatureUtils.parseFragmentSignature(this.configuration, elementAttrValue)) != null && referenceValue.equals(signatureFragmentName = fragmentSignature.getFragmentName());
    }
}

