/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.templatemode;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templatemode.TemplateModeHandler;
import org.thymeleaf.templateparser.html.LegacyHtml5TemplateParser;
import org.thymeleaf.templateparser.xmlsax.XhtmlAndHtml5NonValidatingSAXTemplateParser;
import org.thymeleaf.templateparser.xmlsax.XhtmlValidatingSAXTemplateParser;
import org.thymeleaf.templateparser.xmlsax.XmlNonValidatingSAXTemplateParser;
import org.thymeleaf.templateparser.xmlsax.XmlValidatingSAXTemplateParser;
import org.thymeleaf.templatewriter.XhtmlHtml5TemplateWriter;
import org.thymeleaf.templatewriter.XmlTemplateWriter;

public final class StandardTemplateModeHandlers {
    private static final int MAX_PARSERS_POOL_SIZE = 24;
    public static final ITemplateModeHandler XML;
    public static final ITemplateModeHandler VALIDXML;
    public static final ITemplateModeHandler XHTML;
    public static final ITemplateModeHandler VALIDXHTML;
    public static final ITemplateModeHandler HTML5;
    public static final ITemplateModeHandler LEGACYHTML5;
    public static final Set<ITemplateModeHandler> ALL_TEMPLATE_MODE_HANDLERS;

    private StandardTemplateModeHandlers() {
    }

    static {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int poolSize = Math.min(availableProcessors <= 2 ? availableProcessors : availableProcessors - 1, 24);
        XML = new TemplateModeHandler("XML", new XmlNonValidatingSAXTemplateParser(poolSize), new XmlTemplateWriter());
        VALIDXML = new TemplateModeHandler("VALIDXML", new XmlValidatingSAXTemplateParser(poolSize), new XmlTemplateWriter());
        XHTML = new TemplateModeHandler("XHTML", new XhtmlAndHtml5NonValidatingSAXTemplateParser(poolSize), new XhtmlHtml5TemplateWriter());
        VALIDXHTML = new TemplateModeHandler("VALIDXHTML", new XhtmlValidatingSAXTemplateParser(poolSize), new XhtmlHtml5TemplateWriter());
        HTML5 = new TemplateModeHandler("HTML5", new XhtmlAndHtml5NonValidatingSAXTemplateParser(poolSize), new XhtmlHtml5TemplateWriter());
        LEGACYHTML5 = new TemplateModeHandler("LEGACYHTML5", new LegacyHtml5TemplateParser("LEGACYHTML5", poolSize), new XhtmlHtml5TemplateWriter());
        ALL_TEMPLATE_MODE_HANDLERS = new HashSet<ITemplateModeHandler>(Arrays.asList(XML, VALIDXML, XHTML, VALIDXHTML, HTML5, LEGACYHTML5));
    }
}

