/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.thymeleaf.exceptions.TemplateProcessingException;

@Deprecated
public final class UrlUtils {
    public static String encodeQueryParam(String queryParam) {
        if (queryParam == null) {
            return null;
        }
        if (queryParam.length() == 0) {
            return queryParam;
        }
        try {
            return URLEncoder.encode(queryParam, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateProcessingException("Exception while processing URL encoding", e);
        }
    }

    public static String encodePath(String path) {
        return UrlUtils.encodeString(path, EncodeType.PATH);
    }

    public static String encodePathSegment(String pathSegment) {
        return UrlUtils.encodeString(pathSegment, EncodeType.PATH_SEGMENT);
    }

    static String encodeString(String target, EncodeType type) {
        if (target == null) {
            return target;
        }
        int targetLen = target.length();
        for (int i = 0; i < targetLen; ++i) {
            char c = target.charAt(i);
            if (type.isAllowed(c)) continue;
            return UrlUtils.doEncodeString(target, type);
        }
        return target;
    }

    private static String doEncodeString(String target, EncodeType type) {
        int targetLen = target.length();
        StringBuilder strBuilder = new StringBuilder(targetLen + 5);
        for (int i = 0; i < targetLen; ++i) {
            byte[] charAsBytes;
            char c = target.charAt(i);
            if (type.isAllowed(c)) {
                strBuilder.append(c);
                continue;
            }
            try {
                charAsBytes = new String(new char[]{c}).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new TemplateProcessingException("Exception while processing URL encoding", e);
            }
            for (byte b : charAsBytes) {
                strBuilder.append('%');
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                strBuilder.append(hex1);
                strBuilder.append(hex2);
            }
        }
        return strBuilder.toString();
    }

    private UrlUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncodeType {
        PATH{

            public boolean isAllowed(char c) {
                return EncodeType.isPchar(c) || '/' == c;
            }
        }
        ,
        PATH_SEGMENT{

            public boolean isAllowed(char c) {
                return EncodeType.isPchar(c);
            }
        };


        public abstract boolean isAllowed(char var1);

        private static boolean isPchar(char c) {
            return EncodeType.isUnreserved(c) || EncodeType.isSubDelim(c) || ':' == c || '@' == c;
        }

        private static boolean isUnreserved(char c) {
            return EncodeType.isAlpha(c) || EncodeType.isDigit(c) || '-' == c || '.' == c || '_' == c || '~' == c;
        }

        private static boolean isReserved(char c) {
            return EncodeType.isGenDelim(c) || EncodeType.isSubDelim(c);
        }

        private static boolean isSubDelim(char c) {
            return '!' == c || '$' == c || '&' == c || '\'' == c || '(' == c || ')' == c || '*' == c || '+' == c || ',' == c || ';' == c || '=' == c;
        }

        private static boolean isGenDelim(char c) {
            return ':' == c || '/' == c || '?' == c || '#' == c || '[' == c || ']' == c || '@' == c;
        }

        private static boolean isAlpha(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private static boolean isDigit(char c) {
            return c >= '0' && c <= '9';
        }
    }
}

