/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.unix4j.io.CompositeInput;
import org.unix4j.io.Input;
import org.unix4j.io.NullInput;
import org.unix4j.io.ReaderInput;
import org.unix4j.util.FileUtil;

public class FileInput
extends ReaderInput {
    private final String fileInfo;

    public FileInput(FileReader fileReader) {
        super(fileReader);
        this.fileInfo = fileReader.toString();
    }

    public FileInput(File currentDirectory, File file) {
        super(FileInput.createFileReader(currentDirectory, file));
        this.fileInfo = file.toString();
    }

    public FileInput(File file) {
        super(FileInput.createFileReader(file));
        this.fileInfo = file.toString();
    }

    public FileInput(FileInputStream fileStream) {
        super(new InputStreamReader(fileStream));
        this.fileInfo = fileStream.toString();
    }

    public FileInput(FileDescriptor fileDesc) {
        super(new FileReader(fileDesc));
        this.fileInfo = fileDesc.toString();
    }

    public FileInput(String file) {
        this(new File(file));
    }

    public FileInput(File currentDirectory, String file) {
        this(currentDirectory, new File(file));
    }

    public static List<FileInput> multiple(File ... files) {
        ArrayList<FileInput> inputs = new ArrayList<FileInput>(files.length);
        for (int i = 0; i < files.length; ++i) {
            inputs.add(new FileInput(files[i]));
        }
        return inputs;
    }

    public static List<FileInput> multiple(List<File> files) {
        ArrayList<FileInput> inputs = new ArrayList<FileInput>(files.size());
        for (int i = 0; i < files.size(); ++i) {
            inputs.add(new FileInput(files.get(i)));
        }
        return inputs;
    }

    public static Input composite(File ... files) {
        if (files.length == 0) {
            return NullInput.INSTANCE;
        }
        if (files.length == 1) {
            return new FileInput(files[0]);
        }
        return new CompositeInput(FileInput.multiple(files));
    }

    public static Input composite(List<File> files) {
        if (files.size() == 0) {
            return NullInput.INSTANCE;
        }
        if (files.size() == 1) {
            return new FileInput(files.get(0));
        }
        return new CompositeInput(FileInput.multiple(files));
    }

    private static FileReader createFileReader(File file) {
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileReader createFileReader(File currentDirectory, File path) {
        try {
            File file = FileUtil.toAbsoluteFile(currentDirectory, path);
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileInfo() {
        return this.fileInfo;
    }

    public String getFileInfo(File relativeRoot) {
        try {
            return FileUtil.getRelativePath(relativeRoot, new File(this.fileInfo));
        }
        catch (Exception e) {
            return this.getFileInfo();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fileInfo=" + this.getFileInfo() + ")";
    }
}

