/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.io;

import java.io.IOException;
import java.io.Reader;
import org.unix4j.io.AbstractInput;
import org.unix4j.line.Line;
import org.unix4j.line.SingleCharSequenceLine;

public class ReaderInput
extends AbstractInput {
    private final Reader reader;
    private final char[] buffer = new char[1024];
    private int length;
    private int offset;

    public ReaderInput(Reader reader) {
        this.reader = reader;
        this.readBuffer();
    }

    @Override
    public boolean hasMoreLines() {
        return this.length > this.offset;
    }

    @Override
    public Line readLine() {
        if (this.length == 0) {
            this.readBuffer();
        }
        if (this.length > this.offset) {
            return this.makeLine(null);
        }
        return null;
    }

    private Line makeLine(StringBuilder lineBuilder) {
        int len = this.length;
        int index = this.offset;
        while (true) {
            if (index < len) {
                char ch0 = this.buffer[index];
                if (ch0 == '\n' || ch0 == '\r') {
                    int contentEnd = index++;
                    if (index < len) {
                        char ch1 = this.buffer[index];
                        if ((ch1 == '\n' || ch1 == '\r') && ch0 != ch1) {
                            ++index;
                        }
                        if (lineBuilder == null) {
                            lineBuilder = new StringBuilder(index - this.offset);
                        }
                        lineBuilder.append(this.buffer, this.offset, index - this.offset);
                        if (index < len) {
                            this.offset = index;
                        } else {
                            this.readBuffer();
                        }
                        return new SingleCharSequenceLine(lineBuilder, index - contentEnd);
                    }
                    if (lineBuilder == null) {
                        lineBuilder = new StringBuilder(len - this.offset + 1);
                    }
                    lineBuilder.append(this.buffer, this.offset, len - this.offset);
                    return this.makeLineMaybeWithOneMoreLineEndingChar(lineBuilder);
                }
                ++index;
                continue;
            }
            if (lineBuilder == null) {
                lineBuilder = new StringBuilder(len - this.offset + 16);
            }
            lineBuilder.append(this.buffer, this.offset, len - this.offset);
            this.readBuffer();
            index = this.offset;
            len = this.length;
            if (index >= len) break;
        }
        return lineBuilder.length() > 0 ? new SingleCharSequenceLine(lineBuilder, 0) : null;
    }

    private Line makeLineMaybeWithOneMoreLineEndingChar(StringBuilder lineBuilder) {
        char ch;
        int lineEndingLength = 1;
        this.readBuffer();
        if (this.offset < this.length && ((ch = this.buffer[this.offset]) == '\n' || ch == '\r') && lineBuilder.charAt(lineBuilder.length() - 1) != ch) {
            lineBuilder.append(ch);
            ++lineEndingLength;
            ++this.offset;
        }
        return new SingleCharSequenceLine(lineBuilder, lineEndingLength);
    }

    private void readBuffer() {
        try {
            this.length = this.reader.read(this.buffer);
            this.offset = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

