/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.operation;

import org.unix4j.command.AbstractCommand;
import org.unix4j.command.Arguments;
import org.unix4j.context.ExecutionContext;
import org.unix4j.line.Line;
import org.unix4j.operation.LineOperation;
import org.unix4j.processor.LineProcessor;

public class AdHocCommand
extends AbstractCommand<Args> {
    public static final String NAME = "adhoc";

    public AdHocCommand(LineOperation operation) {
        super(NAME, new Args(operation));
    }

    @Override
    public LineProcessor execute(final ExecutionContext context, final LineProcessor output) {
        return new LineProcessor(){
            final OperationOutput operationOutput;
            final LineOperation operation;
            {
                this.operationOutput = new OperationOutput(output);
                this.operation = ((Args)AdHocCommand.this.getArguments(context)).getOperation();
            }

            @Override
            public boolean processLine(Line line) {
                this.operation.operate(context, line, this.operationOutput);
                return this.operationOutput.isOpen();
            }

            @Override
            public void finish() {
                this.operationOutput.close();
            }
        };
    }

    private static class OperationOutput
    implements LineProcessor {
        private final LineProcessor output;
        private boolean open = true;

        public OperationOutput(LineProcessor output) {
            this.output = output;
        }

        @Override
        public boolean processLine(Line line) {
            if (this.open) {
                this.open = this.output.processLine(line);
                return this.open;
            }
            return false;
        }

        @Override
        public void finish() {
            this.open = false;
        }

        public boolean isOpen() {
            return this.open;
        }

        public void close() {
            this.finish();
            this.output.finish();
        }
    }

    public static final class Args
    implements Arguments<Args> {
        private final LineOperation operation;

        public Args(LineOperation operation) {
            if (operation == null) {
                throw new NullPointerException("operation cannot be null");
            }
            this.operation = operation;
        }

        public final LineOperation getOperation() {
            return this.operation;
        }

        @Override
        public Args getForContext(ExecutionContext context) {
            return this;
        }

        @Override
        public String toString() {
            return "--operation " + this.operation;
        }
    }
}

