/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.option;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import org.unix4j.option.Option;
import org.unix4j.option.OptionSet;

public class DefaultOptionSet<E extends Enum<E>>
implements OptionSet<E>,
Iterable<E>,
Cloneable {
    private final Class<E> optionType;
    private EnumSet<E> options;
    private EnumSet<E> useAcronym;

    public DefaultOptionSet(E option) {
        this.optionType = ((Enum)option).getDeclaringClass();
        this.options = EnumSet.of(option);
        this.useAcronym = EnumSet.noneOf(this.optionType);
    }

    public DefaultOptionSet(E first, E ... rest) {
        this.optionType = ((Enum)first).getDeclaringClass();
        this.options = EnumSet.of(first, rest);
        this.useAcronym = EnumSet.noneOf(this.optionType);
    }

    public DefaultOptionSet(Class<E> optionType) {
        this.optionType = optionType;
        this.options = EnumSet.noneOf(optionType);
        this.useAcronym = EnumSet.noneOf(optionType);
    }

    @Override
    public Class<E> optionType() {
        return this.optionType;
    }

    public void set(E option) {
        this.options.add(option);
    }

    public void setAll(E ... options) {
        for (int i = 0; i < options.length; ++i) {
            this.set(options[i]);
        }
    }

    public void setAll(Collection<? extends E> options) {
        for (Enum option : options) {
            this.set(option);
            this.setUseAcronymFor(option, false);
        }
    }

    public void setAll(OptionSet<E> optionSet) {
        this.options.addAll(optionSet.asSet());
        for (Enum option : (Enum[])this.optionType.getEnumConstants()) {
            this.setUseAcronymFor(option, optionSet.useAcronymFor((Option)((Object)option)));
        }
    }

    @Override
    public boolean isSet(E option) {
        return this.options.contains(option);
    }

    @Override
    public int size() {
        return this.options.size();
    }

    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    @Override
    public EnumSet<E> asSet() {
        return this.options;
    }

    @Override
    public Iterator<E> iterator() {
        return this.options.iterator();
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultOptionSet) {
            return this.options.equals(((DefaultOptionSet)o).options);
        }
        return false;
    }

    public DefaultOptionSet<E> clone() {
        try {
            DefaultOptionSet clone = (DefaultOptionSet)super.clone();
            clone.options = clone.options.clone();
            clone.useAcronym = clone.useAcronym.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should be cloneable", e);
        }
    }

    @Override
    public boolean useAcronymFor(E option) {
        if (this.useAcronym.contains(option)) {
            if (this.options.contains(option)) {
                return true;
            }
            this.useAcronym.remove(option);
        }
        return false;
    }

    public void setUseAcronymForAll(boolean useAcronym) {
        if (useAcronym) {
            this.useAcronym.addAll(EnumSet.complementOf(this.useAcronym));
        } else {
            this.useAcronym.removeAll(EnumSet.copyOf(this.useAcronym));
        }
    }

    public void setUseAcronymFor(E option, boolean useAcronym) {
        if (useAcronym) {
            this.useAcronym.add(option);
        } else {
            this.useAcronym.remove(option);
        }
    }

    public String toString() {
        return DefaultOptionSet.toString(this);
    }

    public static <O extends Option> String toString(OptionSet<O> optionSet) {
        StringBuilder sb = new StringBuilder();
        for (Option opt : optionSet) {
            if (!optionSet.useAcronymFor(opt)) continue;
            if (sb.length() == 0) {
                sb.append("-");
            }
            sb.append(opt.acronym());
        }
        for (Option opt : optionSet) {
            if (optionSet.useAcronymFor(opt)) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append("--").append(opt.name());
        }
        return sb.toString();
    }
}

