/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.vafer.jdependency.asm.DependenciesClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getDependenciesOfJar(InputStream pInputStream) throws IOException {
        JarInputStream inputStream = new JarInputStream(pInputStream);
        NullOutputStream nullStream = new NullOutputStream();
        HashSet<String> dependencies = new HashSet<String>();
        try {
            JarEntry entry;
            while ((entry = inputStream.getNextJarEntry()) != null) {
                if (entry.isDirectory()) {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)nullStream);
                    continue;
                }
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    DependenciesClassAdapter v = new DependenciesClassAdapter();
                    new ClassReader((InputStream)inputStream).accept((ClassVisitor)v, 0);
                    dependencies.addAll(v.getDependencies());
                    continue;
                }
                IOUtils.copy((InputStream)inputStream, (OutputStream)nullStream);
            }
        }
        finally {
            inputStream.close();
        }
        return dependencies;
    }

    public static Set<String> getDependenciesOfClass(InputStream pInputStream) throws IOException {
        DependenciesClassAdapter v = new DependenciesClassAdapter();
        new ClassReader(pInputStream).accept((ClassVisitor)v, 8);
        Set<String> depNames = v.getDependencies();
        return depNames;
    }

    public static Set<String> getDependenciesOfClass(Class<?> pClass) throws IOException {
        String resource = "/" + pClass.getName().replace('.', '/') + ".class";
        return DependencyUtils.getDependenciesOfClass(pClass.getResourceAsStream(resource));
    }
}

