/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.formurl;

import aws.smithy.kotlin.runtime.content.Document;
import aws.smithy.kotlin.runtime.io.SdkBuffer;
import aws.smithy.kotlin.runtime.io.SdkBufferedSink;
import aws.smithy.kotlin.runtime.serde.ListSerializer;
import aws.smithy.kotlin.runtime.serde.MapSerializer;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkSerializable;
import aws.smithy.kotlin.runtime.serde.SerializationException;
import aws.smithy.kotlin.runtime.serde.Serializer;
import aws.smithy.kotlin.runtime.serde.StructSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlListSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlMapSerializer;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializerKt;
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlStructSerializer;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0019j\u0002`\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0014H\u0016J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u00105\u001a\u000206H\u0016J!\u00107\u001a\u00020\u00142\u0017\u00108\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001409\u00a2\u0006\u0002\b:H\u0002J\u0010\u00107\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006;"}, d2={"Laws/smithy/kotlin/runtime/serde/formurl/FormUrlSerializer;", "Laws/smithy/kotlin/runtime/serde/Serializer;", "buffer", "Laws/smithy/kotlin/runtime/io/SdkBuffer;", "prefix", "", "(Laws/smithy/kotlin/runtime/io/SdkBuffer;Ljava/lang/String;)V", "getBuffer", "()Laws/smithy/kotlin/runtime/io/SdkBuffer;", "getPrefix", "()Ljava/lang/String;", "beginList", "Laws/smithy/kotlin/runtime/serde/ListSerializer;", "descriptor", "Laws/smithy/kotlin/runtime/serde/SdkFieldDescriptor;", "beginMap", "Laws/smithy/kotlin/runtime/serde/MapSerializer;", "beginStruct", "Laws/smithy/kotlin/runtime/serde/StructSerializer;", "serializeBigDecimal", "", "value", "Ljava/math/BigDecimal;", "Laws/smithy/kotlin/runtime/content/BigDecimal;", "serializeBigInteger", "Ljava/math/BigInteger;", "Laws/smithy/kotlin/runtime/content/BigInteger;", "serializeBoolean", "", "serializeByte", "", "serializeChar", "", "serializeDocument", "Laws/smithy/kotlin/runtime/content/Document;", "serializeDouble", "", "serializeFloat", "", "serializeInstant", "Laws/smithy/kotlin/runtime/time/Instant;", "format", "Laws/smithy/kotlin/runtime/time/TimestampFormat;", "serializeInt", "", "serializeLong", "", "serializeNull", "serializeSdkSerializable", "Laws/smithy/kotlin/runtime/serde/SdkSerializable;", "serializeShort", "", "serializeString", "toByteArray", "", "write", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "serde-form-url"})
final class FormUrlSerializer
implements Serializer {
    @NotNull
    private final SdkBuffer buffer;
    @NotNull
    private final String prefix;

    public FormUrlSerializer(@NotNull SdkBuffer buffer, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.buffer = buffer;
        this.prefix = prefix;
    }

    public /* synthetic */ FormUrlSerializer(SdkBuffer sdkBuffer, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        this(sdkBuffer, string);
    }

    @NotNull
    public final SdkBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public StructSerializer beginStruct(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlStructSerializer(this, descriptor, this.prefix);
    }

    @NotNull
    public ListSerializer beginList(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlListSerializer(this, descriptor);
    }

    @NotNull
    public MapSerializer beginMap(@NotNull SdkFieldDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return new FormUrlMapSerializer(this, descriptor);
    }

    @NotNull
    public byte[] toByteArray() {
        return this.buffer.readByteArray();
    }

    private final void write(Function1<? super SdkBuffer, Unit> block) {
        SdkBuffer sdkBuffer = this.buffer;
        block.invoke((Object)sdkBuffer);
    }

    private final void write(String value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ String $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                SdkBufferedSink.DefaultImpls.writeUtf8$default((SdkBufferedSink)((SdkBufferedSink)$this$write), (String)FormUrlSerializerKt.access$encode(this.$value), (int)0, (int)0, (int)6, null);
            }
        }));
    }

    public void serializeBoolean(boolean value) {
        this.write(String.valueOf(value));
    }

    public void serializeByte(byte value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ byte $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeChar(char value) {
        this.write(String.valueOf(value));
    }

    public void serializeShort(short value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ short $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeInt(int value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ int $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeLong(long value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ long $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeFloat(float value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ float $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, Float.valueOf(this.$value));
            }
        }));
    }

    public void serializeDouble(double value) {
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ double $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeBigInteger(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write((Function1<? super SdkBuffer, Unit>)((Function1)new Function1<SdkBuffer, Unit>(value){
            final /* synthetic */ BigInteger $value;
            {
                this.$value = $value;
                super(1);
            }

            public final void invoke(@NotNull SdkBuffer $this$write) {
                Intrinsics.checkNotNullParameter((Object)$this$write, (String)"$this$write");
                FormUrlSerializerKt.access$commonWriteNumber($this$write, this.$value);
            }
        }));
    }

    public void serializeBigDecimal(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
        this.write(string);
    }

    public void serializeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.write(value);
    }

    public void serializeInstant(@NotNull Instant value, @NotNull TimestampFormat format) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.serializeString(value.format(format));
    }

    public void serializeSdkSerializable(@NotNull SdkSerializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.serialize((Serializer)this);
    }

    public void serializeNull() {
        throw new SerializationException("null values not supported by form-url serializer");
    }

    public void serializeDocument(@Nullable Document value) {
        throw new SerializationException("document values not supported by form-url serializer");
    }
}

