/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.deserialization;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.LexerState;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStream;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStreamKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.XmlLexerKt;
import aws.smithy.kotlin.runtime.text.Utf8Kt;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.CharCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0080\b\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\u001fH\u0002J\f\u0010\"\u001a\u00020\u0016*\u00020\u0010H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer;", "", "source", "Laws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream;", "(Laws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream;)V", "endOfDocument", "", "getEndOfDocument", "()Z", "getSource$serde_xml", "()Laws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream;", "state", "Laws/smithy/kotlin/runtime/serde/xml/deserialization/LexerState;", "error", "", "msg", "", "error$serde_xml", "parseNext", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "readAttribute", "Lkotlin/Pair;", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken$QualifiedName;", "readCdata", "readName", "readQuoted", "readReference", "", "readTagToken", "readTextToken", "skipComment", "", "skipPreprocessingInstructions", "skipSpace", "qualify", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nXmlLexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlLexer.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer\n+ 2 StringTextStream.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n50#1:342\n50#1:355\n50#1:368\n50#1:382\n50#1:395\n50#1:408\n50#1:421\n50#1:434\n50#1:450\n50#1:463\n94#2,12:330\n94#2,12:343\n94#2,12:356\n94#2,12:369\n94#2,12:383\n94#2,12:396\n94#2,12:409\n94#2,12:422\n94#2,12:435\n94#2,12:451\n94#2,12:464\n1#3:381\n1747#4,3:447\n*S KotlinDebug\n*F\n+ 1 XmlLexer.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer\n*L\n93#1:342\n122#1:355\n129#1:368\n157#1:382\n165#1:395\n177#1:408\n183#1:421\n216#1:434\n320#1:450\n325#1:463\n50#1:330,12\n93#1:343,12\n122#1:356,12\n129#1:369,12\n157#1:383,12\n165#1:396,12\n177#1:409,12\n183#1:422,12\n216#1:435,12\n320#1:451,12\n325#1:464,12\n320#1:447,3\n*E\n"})
public final class XmlLexer {
    @NotNull
    private final StringTextStream source;
    @NotNull
    private LexerState state;

    public XmlLexer(@NotNull StringTextStream source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.state = LexerState.Initial.INSTANCE;
    }

    @NotNull
    public final StringTextStream getSource$serde_xml() {
        return this.source;
    }

    public final boolean getEndOfDocument() {
        return Intrinsics.areEqual((Object)this.state, (Object)LexerState.EndOfDocument.INSTANCE);
    }

    @NotNull
    public final Void error$serde_xml(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$error$serde_xml = false;
        StringTextStream this_$iv = this.getSource$serde_xml();
        boolean $i$f$error$serde_xml2 = false;
        int start$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv) - 3);
        int end$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv) - 1, StringTextStream.access$getOffset$p(this_$iv) + 3);
        String string = StringTextStream.access$getSource$p(this_$iv).substring(start$iv, end$iv + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = StringTextStreamKt.access$getNonAscii$p();
        String string2 = "\u00b7";
        String snippet$iv = regex.replace(charSequence, string2);
        int caretPos$iv = StringTextStream.access$getOffset$p(this_$iv) - start$iv;
        String caret$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv) + '^';
        String locationMultilineString$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv) + " (showing range " + start$iv + '-' + end$iv + "):\n" + snippet$iv + '\n' + caret$iv;
        String fullMsg$iv = msg + '\n' + locationMultilineString$iv;
        throw new DeserializationException(fullMsg$iv);
    }

    @Nullable
    public final XmlToken parseNext() {
        XmlToken xmlToken;
        LexerState currentState = this.state;
        if (Intrinsics.areEqual((Object)currentState, (Object)LexerState.EndOfDocument.INSTANCE)) {
            xmlToken = null;
        } else if (currentState instanceof LexerState.Tag.EmptyTag) {
            LexerState.Tag.OpenTag openTag = ((LexerState.Tag.EmptyTag)currentState).getParent();
            this.state = openTag != null ? (LexerState)openTag : (LexerState)LexerState.EndOfDocument.INSTANCE;
            xmlToken = new XmlToken.EndElement(currentState.getDepth(), ((LexerState.Tag.EmptyTag)currentState).getName());
        } else if (currentState instanceof LexerState.Tag.OpenTag) {
            xmlToken = this.source.peekMatches("<") && !this.source.peekMatches("<![CDATA[") ? this.readTagToken() : this.readTextToken();
        } else if (Intrinsics.areEqual((Object)currentState, (Object)LexerState.Initial.INSTANCE)) {
            this.skipPreprocessingInstructions();
            this.state = LexerState.BeforeRootTag.INSTANCE;
            xmlToken = this.parseNext();
        } else if (Intrinsics.areEqual((Object)currentState, (Object)LexerState.BeforeRootTag.INSTANCE)) {
            this.skipSpace();
            xmlToken = this.readTagToken();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return xmlToken;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<XmlToken.QualifiedName, String> readAttribute() {
        XmlToken.QualifiedName name = this.readName();
        this.skipSpace();
        char equals = this.source.readOrThrow("trying to read attribute equals");
        if (equals != '=') {
            void this_$iv;
            XmlLexer xmlLexer = this;
            String msg$iv = "Unexpected '" + equals + "' while trying to read attribute equals";
            boolean $i$f$error$serde_xml = false;
            StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
            boolean $i$f$error$serde_xml2 = false;
            int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
            int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
            String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        this.skipSpace();
        String value = this.readQuoted();
        return TuplesKt.to((Object)name, (Object)value);
    }

    private final String readCdata() {
        String body = this.source.readUntil("]]>", "trying to read CDATA content");
        this.source.advance(3, "trying to read end of CATA");
        return body;
    }

    private final XmlToken.QualifiedName readName() {
        return this.qualify(this.source.readWhileXmlName());
    }

    /*
     * WARNING - void declaration
     */
    private final String readQuoted() {
        StringBuilder stringBuilder;
        char quoteChar = this.source.readOrThrow("trying to read attribute value");
        if (quoteChar != '\'' && quoteChar != '\"') {
            void this_$iv;
            XmlLexer xmlLexer = this;
            String msg$iv = "Unexpected '" + quoteChar + "' while trying to read attribute value";
            boolean $i$f$error$serde_xml = false;
            StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
            boolean $i$f$error$serde_xml2 = false;
            int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
            int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
            String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        StringBuilder $this$readQuoted_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        while (true) {
            char c;
            if ((c = this.source.readOrThrow("trying to read a string")) == '&') {
                $this$readQuoted_u24lambda_u240.append(this.readReference());
                continue;
            }
            if (c == '<') {
                void this_$iv;
                XmlLexer $i$f$error$serde_xml2 = this;
                String msg$iv = "Unexpected '<' while trying to read a string";
                boolean $i$f$error$serde_xml = false;
                StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
                boolean $i$f$error$serde_xml3 = false;
                int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
                int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
                String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence fullMsg$iv$iv = string;
                Regex regex = StringTextStreamKt.access$getNonAscii$p();
                String string3 = "\u00b7";
                String snippet$iv$iv = regex.replace(fullMsg$iv$iv, string3);
                int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
                String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
                String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
                String fullMsg$iv$iv2 = msg$iv + '\n' + locationMultilineString$iv$iv;
                throw new DeserializationException(fullMsg$iv$iv2);
            }
            if (c == quoteChar) break;
            $this$readQuoted_u24lambda_u240.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final char[] readReference() {
        String ref = this.source.readUntil(";", "trying to read a char/entity reference");
        this.source.advance(1, "trying to read the end of a char/entity reference");
        MatchResult decimalMatch = XmlLexerKt.access$getDecimalCharRef$p().matchEntire((CharSequence)ref);
        if (decimalMatch != null) {
            int code = Integer.parseInt((String)decimalMatch.getGroupValues().get(1));
            return Utf8Kt.codePointToChars((CharCompanionObject)CharCompanionObject.INSTANCE, (int)code);
        }
        MatchResult hexMatch = XmlLexerKt.access$getHexCharRef$p().matchEntire((CharSequence)ref);
        if (hexMatch != null) {
            int code = Integer.parseInt((String)hexMatch.getGroupValues().get(1), CharsKt.checkRadix((int)16));
            return Utf8Kt.codePointToChars((CharCompanionObject)CharCompanionObject.INSTANCE, (int)code);
        }
        Object v = XmlLexerKt.access$getNamedRefs$p().get(ref);
        if (v == null) {
            void this_$iv;
            boolean bl = false;
            XmlLexer xmlLexer = this;
            String msg$iv = "Unknown reference '" + ref + '\'';
            boolean $i$f$error$serde_xml = false;
            StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
            boolean $i$f$error$serde_xml2 = false;
            int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
            int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
            String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        return (char[])v;
    }

    /*
     * WARNING - void declaration
     */
    private final XmlToken readTagToken() {
        XmlToken xmlToken;
        Object actualName;
        LexerState.Tag.OpenTag openTagState;
        char lt = this.source.readOrThrow("looking for the start of a tag");
        if (lt != '<') {
            void this_$iv;
            XmlLexer xmlLexer = this;
            String msg$iv = "Unexpected character '" + lt + "' while looking for the start of a tag";
            boolean $i$f$error$serde_xml = false;
            StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
            boolean $i$f$error$serde_xml2 = false;
            int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
            int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
            String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        if (this.source.advanceIf("!--")) {
            this.skipComment();
            XmlToken xmlToken2 = this.parseNext();
            Intrinsics.checkNotNull((Object)xmlToken2);
            return xmlToken2;
        }
        if (this.source.advanceIf("/")) {
            LexerState lexerState = this.state;
            Intrinsics.checkNotNull((Object)lexerState, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.deserialization.LexerState.Tag.OpenTag");
            openTagState = (LexerState.Tag.OpenTag)lexerState;
            XmlToken.QualifiedName expectedName = openTagState.getName();
            actualName = this.readName();
            if (!Intrinsics.areEqual((Object)actualName, (Object)expectedName)) {
                void this_$iv;
                XmlLexer $i$f$error$serde_xml2 = this;
                String msg$iv = "Unexpected '/" + actualName + "' tag while looking for '/" + expectedName + "' tag";
                boolean $i$f$error$serde_xml = false;
                StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
                boolean $i$f$error$serde_xml3 = false;
                int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
                int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
                String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence fullMsg$iv$iv = string;
                Regex regex = StringTextStreamKt.access$getNonAscii$p();
                String string3 = "\u00b7";
                String snippet$iv$iv = regex.replace(fullMsg$iv$iv, string3);
                int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
                String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
                String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
                String fullMsg$iv$iv2 = msg$iv + '\n' + locationMultilineString$iv$iv;
                throw new DeserializationException(fullMsg$iv$iv2);
            }
            this.skipSpace();
            char ch = this.source.readOrThrow("looking for the end of a tag");
            if (ch != '>') {
                void this_$iv;
                XmlLexer msg$iv = this;
                String msg$iv2 = "Unexpected character '" + ch + "' while looking for the end of a tag";
                boolean $i$f$error$serde_xml = false;
                StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
                boolean $i$f$error$serde_xml4 = false;
                int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
                int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
                String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence caret$iv$iv = string;
                Regex locationMultilineString$iv$iv = StringTextStreamKt.access$getNonAscii$p();
                String snippet$iv$iv = "\u00b7";
                String snippet$iv$iv2 = locationMultilineString$iv$iv.replace(caret$iv$iv, snippet$iv$iv);
                int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
                String caret$iv$iv2 = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
                String locationMultilineString$iv$iv2 = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv2 + '\n' + caret$iv$iv2;
                String fullMsg$iv$iv = msg$iv2 + '\n' + locationMultilineString$iv$iv2;
                throw new DeserializationException(fullMsg$iv$iv);
            }
            LexerState.Tag.OpenTag openTag = openTagState.getParent();
            this.state = openTag != null ? (LexerState)openTag : (LexerState)LexerState.EndOfDocument.INSTANCE;
            xmlToken = new XmlToken.EndElement(openTagState.getDepth(), (XmlToken.QualifiedName)actualName);
        } else {
            LexerState.Tag tag;
            actualName = this.state;
            LexerState.Tag.OpenTag openTag = actualName instanceof LexerState.Tag.OpenTag ? (LexerState.Tag.OpenTag)actualName : null;
            openTagState = openTag != null ? LexerState.Tag.OpenTag.copy$default(openTag, null, null, true, 3, null) : null;
            XmlToken.QualifiedName name = this.readName();
            this.skipSpace();
            Map allAttributes = new LinkedHashMap();
            boolean selfClosingTag = false;
            while (true) {
                char c;
                if ((c = this.source.readOrThrow("looking for the end of a tag")) == '/') {
                    selfClosingTag = true;
                    break;
                }
                if (c == '>') break;
                this.source.rewind(1, "looking for the beginning of an attribute");
                Map msg$iv2 = allAttributes;
                Pair<XmlToken.QualifiedName, String> $i$f$error$serde_xml = this.readAttribute();
                msg$iv2.put($i$f$error$serde_xml.getFirst(), $i$f$error$serde_xml.getSecond());
                this.skipSpace();
            }
            Pair pair = XmlLexerKt.access$extractNsDeclarations(allAttributes);
            Map attributes = (Map)pair.component1();
            List nsDeclarations = (List)pair.component2();
            if (selfClosingTag) {
                char gt = this.source.readOrThrow("looking for the end of a tag");
                if (gt != '>') {
                    void this_$iv;
                    XmlLexer start$iv$iv = this;
                    String msg$iv = "Unexpected characters while looking for the end of a tag";
                    boolean $i$f$error$serde_xml = false;
                    StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
                    boolean $i$f$error$serde_xml5 = false;
                    int start$iv$iv2 = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
                    int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
                    String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv2, end$iv$iv + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    CharSequence charSequence = string;
                    Regex regex = StringTextStreamKt.access$getNonAscii$p();
                    String string4 = "\u00b7";
                    String snippet$iv$iv = regex.replace(charSequence, string4);
                    int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv2;
                    String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
                    String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv2 + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
                    String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
                    throw new DeserializationException(fullMsg$iv$iv);
                }
                tag = new LexerState.Tag.EmptyTag(name, openTagState);
            } else {
                tag = new LexerState.Tag.OpenTag(name, openTagState, false);
            }
            LexerState.Tag nextState = tag;
            this.state = nextState;
            xmlToken = new XmlToken.BeginElement(nextState.getDepth(), name, attributes, nsDeclarations);
        }
        XmlToken token = xmlToken;
        return token;
    }

    private final XmlToken readTextToken() {
        StringBuilder stringBuilder;
        boolean isBlank = false;
        isBlank = true;
        StringBuilder $this$readTextToken_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        while (true) {
            char nextCh;
            if ((((nextCh = this.source.readOrThrow("reading text node")) == ' ' ? true : nextCh == '\t') ? true : nextCh == '\r') ? true : nextCh == '\n') {
                $this$readTextToken_u24lambda_u242.append(nextCh);
                continue;
            }
            if (nextCh == '<') {
                if (this.source.advanceIf("!--")) {
                    this.skipComment();
                    continue;
                }
                if (this.source.advanceIf("![CDATA[")) {
                    $this$readTextToken_u24lambda_u242.append(this.readCdata());
                    isBlank = false;
                    continue;
                }
                break;
            }
            if (nextCh == '&') {
                isBlank = false;
                $this$readTextToken_u24lambda_u242.append(this.readReference());
                continue;
            }
            isBlank = false;
            $this$readTextToken_u24lambda_u242.append(nextCh);
        }
        this.source.rewind(1, "looking for the beginning of a tag");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String text = string;
        LexerState lexerState = this.state;
        Intrinsics.checkNotNull((Object)lexerState, (String)"null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.xml.deserialization.LexerState.Tag.OpenTag");
        LexerState.Tag.OpenTag openTagState = (LexerState.Tag.OpenTag)lexerState;
        boolean openTagIsMostRecent = openTagState.getSeenChildren();
        boolean closeTagIsNext = this.source.peekMatches("</");
        this.state = LexerState.Tag.OpenTag.copy$default(openTagState, null, null, true, 3, null);
        if (isBlank && (openTagIsMostRecent || !closeTagIsNext)) {
            XmlToken xmlToken = this.parseNext();
            Intrinsics.checkNotNull((Object)xmlToken);
            return xmlToken;
        }
        return new XmlToken.Text(this.state.getDepth(), text);
    }

    private final void skipComment() {
        this.source.readThrough("-->", "looking for the end of a comment");
    }

    private final void skipPreprocessingInstructions() {
        this.skipSpace();
        while (this.source.advanceIf("<?")) {
            this.source.advanceUntilSpace();
            this.skipSpace();
            while (!this.source.advanceIf("?>")) {
                this.readAttribute();
                this.skipSpace();
            }
            this.skipSpace();
        }
    }

    private final void skipSpace() {
        this.source.advanceWhileSpace();
    }

    /*
     * WARNING - void declaration
     */
    private final XmlToken.QualifiedName qualify(String $this$qualify) {
        XmlToken.QualifiedName qualifiedName;
        boolean bl;
        Object $this$any$iv;
        List parts;
        block8: {
            char[] cArray = new char[]{':'};
            parts = StringsKt.split$default((CharSequence)$this$qualify, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    if (!(((CharSequence)p0).length() == 0)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            void this_$iv;
            $this$any$iv = this;
            String msg$iv = "Cannot understand qualified name '" + $this$qualify + '\'';
            boolean $i$f$error$serde_xml = false;
            StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
            boolean $i$f$error$serde_xml2 = false;
            int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
            int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
            String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            Regex regex = StringTextStreamKt.access$getNonAscii$p();
            String string2 = "\u00b7";
            String snippet$iv$iv = regex.replace(charSequence, string2);
            int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
            String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
            String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
            String fullMsg$iv$iv = msg$iv + '\n' + locationMultilineString$iv$iv;
            throw new DeserializationException(fullMsg$iv$iv);
        }
        switch (parts.size()) {
            case 1: {
                qualifiedName = new XmlToken.QualifiedName((String)parts.get(0), null, 2, null);
                break;
            }
            case 2: {
                qualifiedName = new XmlToken.QualifiedName((String)parts.get(1), (String)parts.get(0));
                break;
            }
            default: {
                void this_$iv;
                XmlLexer msg$iv = this;
                String msg$iv2 = "Cannot understand qualified name '" + $this$qualify + '\'';
                boolean $i$f$error$serde_xml = false;
                StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
                boolean $i$f$error$serde_xml3 = false;
                int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
                int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
                String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                CharSequence caret$iv$iv = string;
                Regex locationMultilineString$iv$iv = StringTextStreamKt.access$getNonAscii$p();
                String snippet$iv$iv = "\u00b7";
                String snippet$iv$iv2 = locationMultilineString$iv$iv.replace(caret$iv$iv, snippet$iv$iv);
                int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
                String caret$iv$iv2 = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
                String locationMultilineString$iv$iv2 = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv2 + '\n' + caret$iv$iv2;
                String fullMsg$iv$iv = msg$iv2 + '\n' + locationMultilineString$iv$iv2;
                throw new DeserializationException(fullMsg$iv$iv);
            }
        }
        return qualifiedName;
    }
}

