/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.telemetry.logging;

import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.LogLevel;
import aws.smithy.kotlin.runtime.telemetry.logging.LogRecordBuilder;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J \u0010\u0012\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J \u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0016\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016J \u0010\u0017\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Laws/smithy/kotlin/runtime/telemetry/logging/ContextAwareLogger;", "Laws/smithy/kotlin/runtime/telemetry/logging/Logger;", "context", "Lkotlin/coroutines/CoroutineContext;", "delegate", "sourceComponent", "", "(Lkotlin/coroutines/CoroutineContext;Laws/smithy/kotlin/runtime/telemetry/logging/Logger;Ljava/lang/String;)V", "atLevel", "Laws/smithy/kotlin/runtime/telemetry/logging/LogRecordBuilder;", "level", "Laws/smithy/kotlin/runtime/telemetry/logging/LogLevel;", "debug", "", "t", "", "msg", "Lkotlin/Function0;", "error", "info", "isEnabledFor", "", "trace", "warn", "telemetry-api"})
final class ContextAwareLogger
implements Logger {
    @NotNull
    private final CoroutineContext context;
    @NotNull
    private final Logger delegate;
    @NotNull
    private final String sourceComponent;

    public ContextAwareLogger(@NotNull CoroutineContext context, @NotNull Logger delegate, @NotNull String sourceComponent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
        this.context = context;
        this.delegate = delegate;
        this.sourceComponent = sourceComponent;
    }

    @Override
    public void trace(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        CoroutineContextLogExtKt.trace(this.context, this.sourceComponent, t, msg);
    }

    @Override
    public void debug(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        CoroutineContextLogExtKt.debug(this.context, this.sourceComponent, t, msg);
    }

    @Override
    public void info(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        CoroutineContextLogExtKt.info(this.context, this.sourceComponent, t, msg);
    }

    @Override
    public void warn(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        CoroutineContextLogExtKt.warn(this.context, this.sourceComponent, t, msg);
    }

    @Override
    public void error(@Nullable Throwable t, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        CoroutineContextLogExtKt.error(this.context, this.sourceComponent, t, msg);
    }

    @Override
    public boolean isEnabledFor(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.delegate.isEnabledFor(level);
    }

    @Override
    @NotNull
    public LogRecordBuilder atLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        return this.delegate.atLevel(level);
    }
}

