/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.amplifybackend;

import javax.annotation.Generated;

import com.amazonaws.services.amplifybackend.model.*;

/**
 * Abstract implementation of {@code AWSAmplifyBackendAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSAmplifyBackendAsync extends AbstractAWSAmplifyBackend implements AWSAmplifyBackendAsync {

    protected AbstractAWSAmplifyBackendAsync() {
    }

    @Override
    public java.util.concurrent.Future<CloneBackendResult> cloneBackendAsync(CloneBackendRequest request) {

        return cloneBackendAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CloneBackendResult> cloneBackendAsync(CloneBackendRequest request,
            com.amazonaws.handlers.AsyncHandler<CloneBackendRequest, CloneBackendResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBackendResult> createBackendAsync(CreateBackendRequest request) {

        return createBackendAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBackendResult> createBackendAsync(CreateBackendRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBackendRequest, CreateBackendResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBackendAPIResult> createBackendAPIAsync(CreateBackendAPIRequest request) {

        return createBackendAPIAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBackendAPIResult> createBackendAPIAsync(CreateBackendAPIRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBackendAPIRequest, CreateBackendAPIResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBackendAuthResult> createBackendAuthAsync(CreateBackendAuthRequest request) {

        return createBackendAuthAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBackendAuthResult> createBackendAuthAsync(CreateBackendAuthRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBackendAuthRequest, CreateBackendAuthResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateBackendConfigResult> createBackendConfigAsync(CreateBackendConfigRequest request) {

        return createBackendConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateBackendConfigResult> createBackendConfigAsync(CreateBackendConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateBackendConfigRequest, CreateBackendConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request) {

        return createTokenAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTokenResult> createTokenAsync(CreateTokenRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTokenRequest, CreateTokenResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendResult> deleteBackendAsync(DeleteBackendRequest request) {

        return deleteBackendAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendResult> deleteBackendAsync(DeleteBackendRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBackendRequest, DeleteBackendResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendAPIResult> deleteBackendAPIAsync(DeleteBackendAPIRequest request) {

        return deleteBackendAPIAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendAPIResult> deleteBackendAPIAsync(DeleteBackendAPIRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBackendAPIRequest, DeleteBackendAPIResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendAuthResult> deleteBackendAuthAsync(DeleteBackendAuthRequest request) {

        return deleteBackendAuthAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteBackendAuthResult> deleteBackendAuthAsync(DeleteBackendAuthRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteBackendAuthRequest, DeleteBackendAuthResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request) {

        return deleteTokenAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTokenResult> deleteTokenAsync(DeleteTokenRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTokenRequest, DeleteTokenResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GenerateBackendAPIModelsResult> generateBackendAPIModelsAsync(GenerateBackendAPIModelsRequest request) {

        return generateBackendAPIModelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GenerateBackendAPIModelsResult> generateBackendAPIModelsAsync(GenerateBackendAPIModelsRequest request,
            com.amazonaws.handlers.AsyncHandler<GenerateBackendAPIModelsRequest, GenerateBackendAPIModelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBackendResult> getBackendAsync(GetBackendRequest request) {

        return getBackendAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBackendResult> getBackendAsync(GetBackendRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBackendRequest, GetBackendResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBackendAPIResult> getBackendAPIAsync(GetBackendAPIRequest request) {

        return getBackendAPIAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBackendAPIResult> getBackendAPIAsync(GetBackendAPIRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBackendAPIRequest, GetBackendAPIResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBackendAPIModelsResult> getBackendAPIModelsAsync(GetBackendAPIModelsRequest request) {

        return getBackendAPIModelsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBackendAPIModelsResult> getBackendAPIModelsAsync(GetBackendAPIModelsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBackendAPIModelsRequest, GetBackendAPIModelsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBackendAuthResult> getBackendAuthAsync(GetBackendAuthRequest request) {

        return getBackendAuthAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBackendAuthResult> getBackendAuthAsync(GetBackendAuthRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBackendAuthRequest, GetBackendAuthResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetBackendJobResult> getBackendJobAsync(GetBackendJobRequest request) {

        return getBackendJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetBackendJobResult> getBackendJobAsync(GetBackendJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetBackendJobRequest, GetBackendJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTokenResult> getTokenAsync(GetTokenRequest request) {

        return getTokenAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTokenResult> getTokenAsync(GetTokenRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTokenRequest, GetTokenResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListBackendJobsResult> listBackendJobsAsync(ListBackendJobsRequest request) {

        return listBackendJobsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListBackendJobsResult> listBackendJobsAsync(ListBackendJobsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListBackendJobsRequest, ListBackendJobsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RemoveAllBackendsResult> removeAllBackendsAsync(RemoveAllBackendsRequest request) {

        return removeAllBackendsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RemoveAllBackendsResult> removeAllBackendsAsync(RemoveAllBackendsRequest request,
            com.amazonaws.handlers.AsyncHandler<RemoveAllBackendsRequest, RemoveAllBackendsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RemoveBackendConfigResult> removeBackendConfigAsync(RemoveBackendConfigRequest request) {

        return removeBackendConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RemoveBackendConfigResult> removeBackendConfigAsync(RemoveBackendConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<RemoveBackendConfigRequest, RemoveBackendConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendAPIResult> updateBackendAPIAsync(UpdateBackendAPIRequest request) {

        return updateBackendAPIAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendAPIResult> updateBackendAPIAsync(UpdateBackendAPIRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBackendAPIRequest, UpdateBackendAPIResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendAuthResult> updateBackendAuthAsync(UpdateBackendAuthRequest request) {

        return updateBackendAuthAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendAuthResult> updateBackendAuthAsync(UpdateBackendAuthRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBackendAuthRequest, UpdateBackendAuthResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendConfigResult> updateBackendConfigAsync(UpdateBackendConfigRequest request) {

        return updateBackendConfigAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendConfigResult> updateBackendConfigAsync(UpdateBackendConfigRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBackendConfigRequest, UpdateBackendConfigResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendJobResult> updateBackendJobAsync(UpdateBackendJobRequest request) {

        return updateBackendJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateBackendJobResult> updateBackendJobAsync(UpdateBackendJobRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateBackendJobRequest, UpdateBackendJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
